#include <iostream.h>
#include <asm/io.h>
#include <unistd.h>
#include <fstream.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
int port70 = 0x70;
int port71 = 0x71;
unsigned char value;
int amount;
int val;
char ans;
int addr;
char c;
char filename [12];
menu();
delcmos();
savecmos();
loadcmos();
hexdump();
writeval();
clrscr();
void main()
{
iopl(3);
clrscr();
cout << "Enter the number of bytes the CMOS uses (64, 128, 2048).\nIf you don't know, enter 64: ";
cin >> amount;
for(;;)
     {  
	menu();
	
	switch (ans)
	{
	case '1':
	delcmos();
	break;

	case '2':
	savecmos();
	break;

	case '3':
	loadcmos();
	break;

	case '4':
	hexdump();
	break;

	case '5':
	writeval();
	break;
	case '6':
	exit(0);
	break;

	default:
	   clrscr();
	   cout << "\""<< ans <<"\"  is not a valid option! Press enter to continue";
	   getchar();
	   getchar();
	 break;
	}

}

}

int menu()
{
clrscr();
cout << "################################ CMOS TOOL v1.0 ##############################\n"; cout << "\n";
cout << " 1  Delete the current values in CMOS memory\n";
cout << " 2  Save current CMOS values to a file\n";
cout << " 3  Load values from a file into CMOS memory\n";
cout << " 4  Hex dump of CMOS memory\n";
cout << " 5  Write a value to a CMOS memory location (I hope you know what you're doing)\n";
cout << " 6  Quit\n\n";
cout << "Enter option:  ";
ans = 0;
cin  >> ans;
return 1;
}

int delcmos()
{
for(int count=0;count<amount;count++)
{
 outb(count,port70);
 outb(0x0000,port71);
}
return 1;
}

int savecmos()
{
clrscr();
ofstream fp;
cout << "Enter a filename to save CMOS to: ";
cin >> filename;
fp.open(filename);
  for(int count=0;count<amount;count++)
     {
	
	 outb(count,port70);
	 value=inb(port71);
	 fp << value;
     }
fp.close();
return 1;
}


int loadcmos()
{
clrscr();
ifstream fp;
cout << "Enter a filename to load CMOS from: ";
cin >> filename;
fp.open(filename);
for(int count=0;count<amount;count++)
{
fp.get(value);
 outb(count,port70);
 outb(value,port71);


}
fp.close();
return 1;
}

int hexdump()
{
clrscr();
 for(int count=0;count<amount;count++)
 {
 outb(count,port70);
 value=inb(port71);
 printf("%04x ",value);
 }
 cout << "\n Press the enter key to continue.";
   getchar();
   getchar();
 return 1;
}

int writeval()
{
 addr=0;
 cout << " Address (In hex): ";
 cin >>hex>>addr;
 cout << "\nValue (In hex): ";
 cin >>hex>> val;  
 outb(addr,port70);
 outb(val,port71);
return 1;
}

int clrscr()
{
   system("clear");
return 1;   
}

