* This program reads dtext.dat and recreates the file textdata.dat
* that is distributed with other versions of Dungeon.  The text file
* can be used to correct spelling errors, descriptions, etc., and
* should have been distributed with this version.  Use the program
* textcnv.f to convert textdata.dat back into the binary, encrypted
* dtext.dat file. -- RR Slater, Oct 2001

      character*(76) text

      OPEN (UNIT=12,FILE='dtext.dat',STATUS='OLD',
     1FORM='UNFORMATTED',ACCESS='DIRECT',
     2RECL=80,ERR=1950)

      open( unit=16, file='textdata.dat', status='new' )

      jasc = 1
      ilen = 1
10    continue
      read(12,rec=jasc,err=1000,end=100) iasc, text
      if( iasc .eq. -1 ) then			! EOF marker found
        text = 'END OF DATA BASE FILE'
        write(16,'(i5,a)') iasc, text
        stop
      endif
      call decrpt( jasc, text )			! decrypt the text
      do 20 j=76,1,-1				! trim right spaces
        if( text(j:j) .ne. ' ' ) then
          ilen = j
          go to 30
        endif
20    continue
c     Text is only spaces.  Write out record number.
      write(16,'(i5)') iasc
      jasc = jasc + 1
      go to 10
30    continue
      write(16,'(i5,a)') iasc, text(1:ilen)
      jasc = jasc + 1
      go to 10
100   continue
      stop ' '


1000  print *,'read 12 error'
      stop
1950  print *,'open 12 error'
      end


      subroutine decrpt( ia, t )
      character*(*) t
      implicit integer (a-z)

      do 100 i=1,len(t)
        x = zand(ia,31) + i
        t(i:i) = char( zxor(ichar(t(i:i)),x) )
100   continue
      return
      end

* From machdep.f:

C***************************************************C
C                                                   C
C  ALL THESE 'AND'S WITH 65535 ARE IMPORTANT        C
C  LEAVE THEM IN                                    C
C                                                   C
C***************************************************C
C                                                   C
C  FOR THE PC, VAX/VMS AND MY MIPS 120, THESE       C
C      WORK AS-IS.                                  C
C  FOR MANY UNIX MACHINES IAND -> AND, IOR -> OR    C
C      IEOR -> XOR                                  C
C***************************************************C
        INTEGER FUNCTION ZAND(I,J)
	IMPLICIT INTEGER(A-Z)
        ZAND = AND(AND(I,J),65535)
        RETURN
        END
        INTEGER FUNCTION ZXOR(I,J)
	IMPLICIT INTEGER(A-Z)
        ZXOR = AND(XOR(I,J),65535)
        RETURN
        END
