/*
 * Memory mit Scaleable Fonts und mehreren geoeffneten Bildschirmen
 */

#ifndef __global_h
#	include "global.H"
#endif
#ifndef __port_h
#	include "port.H"
#endif
#ifndef __board_h
#	include "board.H"
#endif
#ifndef __game_h
#	include "game.H"
#endif
#ifndef __mem_image_h
#	include "mem_image.H"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
// #include <sys/time.h>
#include <sys/types.h>
#ifndef WIN32
#	include <dirent.h>
#endif

#ifndef DATA_DIRECTORY
#	define DATA_DIRECTORY "."
#endif
#define	_DoubleString
#define	DoubleDepth

#define	_TRACE_COLORS

Board *board_p;

#ifndef FONT_DEFAULT
#	define	FONT_DEFAULT "-bitstream-charter-bold-r-*"
#endif

Parameter param[] = {

// parameters for the 'letter' game

{ FONT_DEFAULT, 0, {
	{  4,  5, 44, 100, 100 }, 		// small
	{  6,  7, 44, 100, 100 }, 		// normal
	{ 8,  9, 44, 100, 100 }		// big
}},

// parameters for the 'smiley' game

{ FONT_DEFAULT, 1, {
	{  6,  3, 44, 100, 270 }, 		// small
	{  8,  3, 44, 100, 270 }, 		// normal
	{ 10,  4, 44, 100, 270 }		// big
}},

// parameters for the 'picture' game
{ FONT_DEFAULT, 0, {
	{  5,  4, 100, 100, 150 }, 		// small
	{  7,  4, 100, 100, 150 }, 		// normal
	{  10, 6, 75, 100, 150 }			// big
}}


#ifdef HUBSYM
, // to append to last entry

// parameter for a symbol game (requires special symbol font)

{ "-hub-symbol-normal-r-normal-*", 0, {
	{  4,  5, 44, 100, 70 }, 
	{  6,  9, 44, 100, 70 }, 
	{  8, 11, 44, 100, 70 }
}},

// parameters for the 'cyrillic' game

{ "-hub-textbook-bold-r-normal-*", 0, {
	{  4,  5, 44, 100, 100 }, 		// small
	{  8,  9, 44, 100, 100 }, 		// normal
	{ 11, 12, 44, 100, 100 }		// big
}}
#endif
};


//////////////////////////////////////////////////////////////////////////////

char *find_file( const char *filename ) {
char path[1024];
static char *lookup[] = {
	"./",
#ifdef HUBSYM
	"/home/helmut/src/xmemory-3.X/",
#endif
	 DATA_DIRECTORY "/" };
FILE *fp;

	for(int i=0;i<(int)(sizeof(lookup)/sizeof(char*));i++) {
		strcpy(path,lookup[i]);
		strcat(path,filename);
		fp=fopen(path,"r");
		if (fp)	{ fclose(fp); return strdup(path); }

		strcat(path,".mem");
		fp=fopen(path,"r");
		if (fp)	{ fclose(fp); return strdup(path); }
	}
	return 0;
}

#ifndef WIN32
void scan_dir( const char *dirname ) {
DIR	*dir;
struct dirent *entry;

	dir=opendir(dirname);
	while( (entry=readdir( dir )) != NULL ) {
		if (!strcmp(".mem",&entry->d_name[strlen(entry->d_name)-4])) {
			char *help=strdup(entry->d_name);		// cut extention
			help[strlen(help)-4]=0;
			if (strcmp(help,"default"))				// if not default:
				printf( "       -%s\n", help );			// print name as option
			free(help);
		}
	}
	closedir(dir);
}
#endif

void usage() {
	printf("usage: xmemory <options>\n");
	printf("options:\n");
	printf("    tile selection:\n" );
	printf("       -smiley      - select smiley tiles (default)\n" );
	printf("       -letter      - select letter tiles\n" );
#ifdef HUBSYM
	printf("       -symbol      - select Contronic S symbol font\n" );
	printf("       -cyrillic    - select Contronic S cyrillic font\n" );
#endif
	printf("       -pictures    - select default picture package\n" );
	printf("       -file <name> - use picture file <name>\n" );
	printf("    installed picture packages:\n");
#ifndef WIN32
	scan_dir( "." );
#ifdef HUBSYM
	scan_dir( "/home/helmut/src/xmemory-3.X" );
#endif
	scan_dir( DATA_DIRECTORY );
#endif
	printf("\n    game selection:\n" );
	printf("       -small        - small amount of tiles\n" );
	printf("       -normal       - normal amount of tiles (default)\n" );
	printf("       -big          - large amount of tiles\n" );
	printf("       -remain       - tiles remain on the screen after match\n" );
	printf("       -sync         - play the traditional synchronous games\n" );
	printf("       -tile <w>x<h> - number of tile (total must be even)\n" );
	printf("       -lock <n>     - lock picture size to <n> percent of original\n" );
	printf("\n    player selection:\n" );
	printf("       <display>        - select display for player <n>\n" );
	printf("       <display>/<name> - select display and color <name> for player <n>\n" );
	printf("       -color<n> <name> - select color <name> for player <n>\n" );

	printf("\nAuthor:  Helmut Hoenig, July-17-96 (V3.7)   (Helmut.Hoenig@hub.de)\n" );

	printf("\nsmail (for gifts :-) \n");
	printf("        Helmut Hoenig\n");
	printf("        Hopfenstrasse 8a\n");
	printf("        65520 Bad Camberg\n");
	printf("        GERMANY\n");
	exit(-1);
}

#define MAX_PLAYERS	10

char	*def_col[MAX_PLAYERS] = {		// predefined colors for the first players
	"red",
	"DodgerBlue",
	"OliveDrab",
	"gold",
	"DeepPink",
	"tomato",
	"aquamarine",
	"brown",
	"bisque",
	"sienna" };

char *def_disp[MAX_PLAYERS] = {
	"", "", "", "", "", "", "", "", "", ""
};

main( int argc, char **argv )
{
int i;
long	timefield;
char	main_display[30];
char	*main_p;
char *filename;
int	xmax=0, ymax=0;

	if ( (filename=find_file( "default" ))==0 ) {
		filename="default.mem";
	}

	main_p = getenv("DISPLAY");
	if (main_p) {
		strcpy(main_display,main_p);
		main_p=strstr(main_display,"_XT");
		if (main_p)		main_p+=3;
	}

	time(&timefield);					// preset random generator
	srand((int)timefield);

	Port::nplayers = 0;
	Port::def_size = -1;

	for (i=1;i<argc;i++) {
		     if (!strcmp(argv[i],"-small"   )) { Port::def_size=0; }
		else if (!strcmp(argv[i],"-normal"  )) { Port::def_size=1; }
		else if (!strcmp(argv[i],"-big"     )) { Port::def_size=2; }

		else if (!strcmp(argv[i],"-smiley"  )) { Port::def_mode=Smiley; }
		else if (!strcmp(argv[i],"-pictures" )) { Port::def_mode=Photo; }
		else if (!strcmp(argv[i],"-letter"  )) { Port::def_mode=Normal; }
#ifdef HUBSYM
		else if (!strcmp(argv[i],"-cyrillic")) { Port::def_mode=Cyrillic; }
		else if (!strcmp(argv[i],"-symbol"  )) { Port::def_mode=Symbol; }
#endif
		else if (!strcmp(argv[i],"-file")) {
			Port::def_mode=Photo;
			filename=argv[++i];
		}
		else if (!strcmp(argv[i],"-font")) {
			param[Normal].font = argv[++i];
			param[Smiley].font = argv[  i];
		}
		else if (!strcmp(argv[i],"-remain")) {
			Port::remove_flag=0;
		}
		else if (!strcmp(argv[i],"-sync")) {
			Port::sync_flag=1;
		}
		else if (!strcmp(argv[i],"-lock")) {
			Port::resize_lock = atoi(argv[++i]);
		}
		else if (!strcmp(argv[i],"-tile")) {
			if (sscanf( argv[++i], "%dx%d", &xmax, &ymax )==2) {
				if ( (xmax*ymax)&1 )		xmax--;
			}
			else	xmax=ymax=0;
		}
		else if (!strncmp(argv[i],"-color",6)) {
			int id=atoi(&argv[i][6]);
			if ((id>=0)&&(id<MAX_PLAYERS)) {
				def_col[id] = argv[++i];
			}
		}
		else if (strrchr(argv[i],':')) {
			char *col=strchr(argv[i],'/');			// compatibility with old params
			if (col) {
				if (col[1])	def_col[Port::nplayers]=col+1;	// color stored
				*col='\0';												// color cut
			}
			def_disp[Port::nplayers++]=argv[i];		// store next display
		}
		else if (argv[i][0]=='/') {					// compatibility with old params
			if (argv[i][1]) {
				def_col[Port::nplayers]=&argv[i][1];
			}
			Port::nplayers++;
		}
		else if (argv[i][0]=='-') {
			if ( (filename=find_file( &argv[i][1] ))!=0 ) {
				Port::def_mode=Photo;
			}
			else	usage();
		}
		else usage();
	}

	if (!Port::nplayers) {
		Port::nplayers++;
	}

	if (Port::def_mode==Photo) {
		int mwidth, mheight;
		Port::gif=new MemImage(filename);
		Port::gif->ShowInfoMsg();

		if (Port::def_size==-1&&xmax==0&&ymax==0) {
			const char *opt=Port::gif->GetExtensionData( OPTION_EXTENSION );

			if (!opt || sscanf( opt, "-tile %dx%d", &xmax, &ymax )!=2) {
				xmax=ymax=0;
			}
		}

		Display *dpy=XOpenDisplay(def_disp[0]);
		if (dpy) {
			mwidth  = WidthOfScreen(DefaultScreenOfDisplay(dpy));
			mheight = HeightOfScreen(DefaultScreenOfDisplay(dpy));
			XCloseDisplay(dpy);
		}
		else {
			mwidth  = 1024;
			mheight = 768;
		}
		Port::gif->SetupParams( &param[Photo], mwidth, mheight );
	}
	else {
		Port::gif=0;
	}

	if (Port::def_size==-1)		Port::def_size=1;

	Port::dwidth  = param[Port::def_mode].dim[Port::def_size].dwidth;
	Port::dheight = param[Port::def_mode].dim[Port::def_size].dheight;
	Port::dsize   = param[Port::def_mode].dim[Port::def_size].dsize;
	Port::wsizex  = param[Port::def_mode].dim[Port::def_size].wsizex;
	Port::wsizey  = param[Port::def_mode].dim[Port::def_size].wsizey;

	if (xmax) {
		Port::dwidth  = xmax;
		Port::dheight = ymax;
	}
	board_p = new Board( Port::dwidth, Port::dheight );

	for (i=0;i<Port::nplayers;i++) {
		new Port( def_disp[i], def_col[i] );
	}

#if (0)
	if (argc<2)		new Port( main_display, def_col[0] );

	for (;i<argc;i++) {
		if ( color_name=strchr(argv[i],'/') ) {
			*color_name++ = '\0';
			if (argv[i][0]=='\0'&&main_p) {
				*main_p = '0'+Port::color_id;
				new Port( main_display, *color_name?color_name:def_col[Port::color_id-1] );
			}
			else {
				new Port( argv[i], *color_name?color_name:def_col[Port::color_id-1] );
			}
		}
		else {
			new Port( argv[i], def_col[Port::color_id-1] );
		}
	}
#endif
	board_p->reset();
	Port::activate_any_player();

#if (1)
	while(!Port::wait_event());
#else
	int	n=10;
	while(--n)							Port::wait_event();
#endif

	Port::statistic();
	Port::close_all();
	delete board_p;

	/* sleep(5); */
	return 0;
}
