#ifndef __board_h
#define __board_h

class Field {
public:
	void reset( int id )
	{ tile_id = id; lock_col = 0; locked=0; found=0; flash=0; gone=0; }

	int		tile_id;	// tile-index, used twice per board of course
		unsigned lock_col	: 4;		// color_id
		unsigned locked	: 1;		// geoeffnet
		unsigned found		: 1;		// Treffer
		unsigned flash		: 1;		// Highligh beim Blinken
		unsigned gone		: 1;		// auf Stapel gelegt
};


class Board {
public:
	Board( int width, int height );
	~Board();

	int check_swap( int op, int np );
	void reset();
	void color_removed(int color_id);
	int  tile_removed(int color_id);
	Field	*field( int x, int y );
	Field	*field( int fid );

	int				ntiles;
	int				tiles_left;
	unsigned long	finished;
	int		dx, dy;		// dimension of board
	Field	*f;
};

#endif
