/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* transporters.h  --  Functions to handle transporters. */


#ifndef TRANSPORTERS_H
#define TRANSPORTERS_H    /* To stop multiple inclusions. */


#include "common.h"


#define MAX_LEN_TRANSPORTERNAME 15
#define ON_THE_WAY 65000

struct transporter_t
{
 guint id;
 gchar name[MAX_LEN_TRANSPORTERNAME+1];
 glong money;
 glong capacity;
 guint location;
 GList *goods;
};

typedef struct transporter_t transporter_t;


#include "players.h"
#include "goods.h"

transporter_t *transporter_new(guint id, const gchar *name, glong money,
                               glong capacity, guint location, GList *goods);

void transporter_free(transporter_t *transporter);
void transporter_free_all(GList *transporters);

transporter_t *transporter_find_by_id(player_t *player, guint id);

gint transporter_drive(player_t *player, guint id, guint destination);

void transporter_add_good(transporter_t *transporter, good_t *good);

glong transporter_free_capacity(transporter_t *transporter);

void transporter_set_name(transporter_t *transporter, const gchar *name);


#endif /* TRANSPORTERS_H */

