/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* trade.c  --  Trading routines. */


#include "common.h"
#include "towns.h"
#include "transporters.h"
#include "protocol.h"

#include "trade.h"


gboolean trade_buymode = TRUE;


/******************************************************************************
 Buy goods from a town and store them in a transporter.
******************************************************************************/
gint trade_buy_from_town_to_transporter(transporter_t *transporter, guint what,
                                        glong amount)
{
 town_t *town = town_find_by_id(transporter->location);
 good_t *town_good = good_find_by_id(town->goods, what);
 good_t *transporter_good = good_find_by_id(transporter->goods, what);


 if (protocol_buy_from_town_to_transporter(transporter->id, what, amount) < 0)
  return -1; 

 /* Transfer goods. */
 town_good->amount -= amount;
 transporter_good->amount += amount;

 /* Transfer money. */
 town->money += amount * town_good->price;
 transporter->money -= amount * town_good->price;

 return 0;
}

/******************************************************************************
 Sell goods from a transporter to a town.
******************************************************************************/
gint trade_sell_from_transporter_to_town(transporter_t *transporter,
                                         guint what, glong amount)
{
 town_t *town = town_find_by_id(transporter->location);
 good_t *town_good = good_find_by_id(town->goods, what);
 good_t *transporter_good = good_find_by_id(transporter->goods, what);


 if (protocol_sell_from_transporter_to_town(transporter->id, what, amount) < 0)
  return -1; 

 /* Transfer goods. */
 town_good->amount += amount;
 transporter_good->amount -= amount;

 /* Transfer money. */
 town->money -= amount * town_good->price;
 transporter->money += amount * town_good->price;

 return 0;
}

/******************************************************************************
 Switch 'trade_buymode' from TRUE to FALSE or vice versa.
******************************************************************************/
void trade_flip_buymode(void)
{
 trade_buymode = !trade_buymode;
}
