/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* towns.h  --  Functions to handle towns. */


#ifndef TOWNS_H
#define TOWNS_H    /* To stop multiple inclusions. */


#include "common.h"


#define MAX_LEN_TOWNNAME 15

typedef struct town_t
{
 guint id;
 gchar name[MAX_LEN_TOWNNAME+1];
 glong money;
 gulong inhabitants;
 GList *goods;
} town_t;

#include "goods.h"

extern GList *towns;

town_t *town_new(guint id, const gchar *name, glong money, gulong inhabitants, 
                 GList *goods);
void town_free(town_t *town);
void town_free_all(void);

town_t *town_find_by_id(guint id);

void town_add(town_t *town);
void town_remove(town_t *town);
void town_add_good(town_t *town, good_t *good);


#endif /* TOWNS_H */

