/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* towns.c  --  Functions to handle towns. */


#include "common.h"
#include "goods.h"

#include "towns.h"


GList *towns = NULL;

/******************************************************************************
 Create a new town.
******************************************************************************/
town_t *town_new(guint id, const gchar *name, glong money, gulong inhabitants,
                 GList *goods)
{
 town_t *town = g_malloc(sizeof(town_t));

 town->id = id;
 g_snprintf(town->name, MAX_LEN_TOWNNAME+1, "%s", name);
 town->money = money;
 town->inhabitants = inhabitants;
 town->goods = goods;

 return town;
}

/******************************************************************************
 Free the memory used by a town.
******************************************************************************/
void town_free(town_t *town)
{
 g_free(town);
}

/******************************************************************************
 Free the memory used by all towns.
******************************************************************************/
void town_free_all(void)
{
 GList *g;
 town_t *town;

 if ((g = g_list_first(towns)) == NULL)
 {
  g_list_free(towns);
  return;
 }

 do
 {
  town = g->data;
  town_free(town);
 } while ((g = g_list_next(g)) != NULL);

 g_list_free(towns);
}

/******************************************************************************
 Find the town with the given ID.
******************************************************************************/
town_t *town_find_by_id(guint id)
{
 GList *g;
 town_t *town;

 if ((g = g_list_first(towns)) == NULL)
  return NULL; /* Town not found. */

 do
 {
  town = g->data;

  if (town->id == id)
   return town;

 } while ((g = g_list_next(g)) != NULL);

 return NULL; /* Town not found. */
}

/******************************************************************************
 Add a town to the list of towns.
******************************************************************************/
void town_add(town_t *town)
{
 towns = g_list_append(towns, town);
}

/******************************************************************************
 Remove a town from the list of towns.
******************************************************************************/
void town_remove(town_t *town)
{
 towns = g_list_remove(towns, town);
}

/******************************************************************************
 Add a good to a town.
******************************************************************************/
void town_add_good(town_t *town, good_t *good)
{
 town->goods = g_list_append(town->goods, good);
}

