/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* sound.h  --  Functions to handle sound output. */


#ifndef SOUND_H
#define SOUND_H    /* To stop multiple inclusions. */


#if HAVE_LIBMIKMOD


#include "common.h"


#define SONG_HOLSHAM1  NHTSCLIENT_DATADIR"/holsham1.xm"
#define SONG_HOLSHAM2  NHTSCLIENT_DATADIR"/holsham2.xm"
#define SONG_ONTHEFAIR NHTSCLIENT_DATADIR"/onthefair.xm"

extern gboolean sound_music_stopped;

gint sound_init(void);
void sound_shutdown(void);

gint sound_load_module(const gchar *filename);
gint sound_play_module(const gchar *filename);
void sound_free_module(void);

gint sound_send_command_to_child(const gchar *message);


#endif /* HAVE_LIBMIKMOD */


#endif /* SOUND_H */

