/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* servercmds.h  --  Functions to handle server commands. */


#ifndef SERVERCMDS_H
#define SERVERCMDS_H    /* To stop multiple inclusions. */


#include "common.h"


gint check_for_servercmds(const gchar *message);

gint servercmd_init(GPtrArray *args);

gint servercmd_chat(GPtrArray *args);

gint servercmd_good_amount_update(GPtrArray *args);
gint servercmd_good_price_update(GPtrArray *args);

gint servercmd_player_new(GPtrArray *args);
gint servercmd_player_remove(GPtrArray *args);
gint servercmd_player_logged_in(GPtrArray *args);
gint servercmd_player_logged_out(GPtrArray *args);

gint servercmd_transporter_arrived(GPtrArray *args);
gint servercmd_transporter_left(GPtrArray *args);

gint servercmd_town_info(GPtrArray *args);


#endif /* SERVERCMDS_H */

