/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* protocol.h  --  htsprotocol implementation. */


#ifndef PROTOCOL_H
#define PROTOCOL_H    /* To stop multiple inclusions. */


#include "common.h"


#define PROTOCOL_VERSION "0.4.6"  /* htsprotocol version we use. */


gint protocol_get_reply_code(const gchar *reply);

gint protocol_addplayer(const gchar *playername, const gchar *password);

gint protocol_login(const gchar *playername, const gchar *password);
gint protocol_logout(void);

gint protocol_adminlogin(const gchar *password);

gint protocol_protocol(void);

gint protocol_buy_from_town_to_transporter(guint transporter, guint what,
                                           glong amount);
gint protocol_sell_from_transporter_to_town(guint transporter, guint what,
                                            glong amount);

gint protocol_transporter_drive(guint transporter, guint destination);

gint protocol_quit(void);


#endif /* PROTOCOL_H */

