/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* nhtsclient.c  --  Main source file for nhtsclient. */


#include "common.h"
#include "misc.h"
#include "cmdline.h"
#include "net.h"
#include "nc.h"
#include "sound.h"
#include "file.h"
#include "conf.h"
#include "log.h"
#include "misc.h"
#include "players.h"
#include "input.h"

#include "nhtsclient.h"


/******************************************************************************
 ...
******************************************************************************/
gint main(gint argc, gchar *argv[])
{
 log_init();

 conf_init();

 parse_arguments(argc, argv);

 init_ncurses();

 if (conf_parse() < 0)
 {
  g_warning("Reading config-file failed.");
  endwin();
  /* shutdown_ncurses(); */
  exit(EXIT_FAILURE);
 }

 setup_signal_handling();

 my_player = player_new(0, "Foo", "Bar", NO, 0, 0, NULL, NULL); /* FIXME */

 display_main_screen();

#if HAVE_LIBMIKMOD
 if (conf.music != NO)
  sound_play_module(SONG_HOLSHAM1);
#endif /* HAVE_LIBMIKMOD */


 net_main_loop();


#if HAVE_LIBMIKMOD
 if (conf.music != NO)
 {
  if (sound_send_command_to_child("quit") >= 0)
   if (wait(NULL) < 0)
    log_perror("signal_handler_child:wait");
 }
#endif /* HAVE_LIBMIKMOD */

 shutdown_ncurses();

 return EXIT_SUCCESS;
}

