/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* net.h  --  Networking code. */


#ifndef NET_H
#define NET_H    /* To stop multiple inclusions. */


#include "common.h"


#define MAX_LEN_SERVERNAME 30

extern GMainLoop *mainloop;

void net_main_loop(void);

gint net_create_socket(const gchar *ip, gushort port);

gint net_connect_to_server(const gchar *hostname, guint port);
void net_close_connection_to_server(void);

gchar *net_read_line_from_server(void);
void net_send_line_to_server(const gchar *fmt, ...);

gboolean net_handle_server_message(GIOChannel *source, GIOCondition condition,
                                   gpointer data);

gchar *net_resolve_hostname(const gchar *hostname);


#endif /* NET_H */

