/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* nc.h  --  Ncurses-related code. */


#ifndef NC_H
#define NC_H    /* To stop multiple inclusions. */


#include "common.h"
#include "transporters.h"
#include "goods.h"


enum
{
 LOCATION_MAIN_SCREEN,
 LOCATION_TRADE_SCREEN,
 LOCATION_PLAYERS_SCREEN
};

/* Cursor attributes. */
enum
{
 INVISIBLE,
 VISIBLE,
 VERYVISIBLE
};

void init_ncurses(void);
void shutdown_ncurses(void);

void display_main_screen(void);

void display_statusbar1(guint location);
void display_statusbar2(guint location);

void display_trade_screen(void);

void print_transporter_info(transporter_t *transporter);
void print_goods(GList *goods, transporter_t *transporter, gint highlighted);

void wfillbox(WINDOW *win, gint x1, gint y1, gint x2, gint y2, chtype ch);
void fillbox(gint x1, gint y1, gint x2, gint y2, chtype ch);

void drawbox(WINDOW *win, gint x1, gint y1, gint x2, gint y2);

void about_box(void);
void help_box(void);

void print_chat_message(const gchar *message);
void print_log_message(const gchar *fmt, ...);

gint xmvwaddstr(WINDOW *win, gint y, gint x, chtype ch, const gchar *message);
gint xmvaddstr(gint y, gint x, chtype ch, const gchar *message);

gint xwclrtoeol(WINDOW *win, chtype ch);
gint xclrtoeol(chtype ch);
gint xmvclrtoeol(gint y, gint x, chtype ch);

gint xmvprintw(gint y, gint x, chtype ch, const gchar *fmt, ...);

gint xbox(WINDOW *win, chtype ch, chtype verch, chtype horch);

guint generic_menu(GPtrArray *ptr_array, chtype ch, const gchar *title,
                   chtype ch_title, chtype ch_fore, chtype ch_back,
                   const gchar *mark);


#endif /* NC_H */

