/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* log.c  --  Logging routines. */


#include "common.h"
#include "file.h"
#include "conf.h"

#include "log.h"


/******************************************************************************
 Initialize logging.
******************************************************************************/
void log_init(void)
{
 (void) g_log_set_handler(NULL, G_LOG_LEVEL_WARNING | G_LOG_LEVEL_MESSAGE
                          | G_LOG_FLAG_FATAL | G_LOG_FLAG_RECURSION,
                          log_to_file, NULL);
}

/******************************************************************************
 Log a message to the logfile.
******************************************************************************/
void log_to_file(const gchar *log_domain, GLogLevelFlags log_level,
                 const gchar *message, gpointer user_data)
{
 gint fd;
 time_t t;
 GIOChannel *channel;
 gchar *log_message;

 if (((fd = open(conf.logfile, O_WRONLY|O_CREAT|O_APPEND, FILEMODE)) < 0))
 {
  if (errno != EEXIST)
  {
   /* shutdown_ncurses(); */
   /* g_warning("Cannot open logfile '%s' (%s).", conf.logfile, g_strerror(errno)); */
   exit(EXIT_FAILURE);
  }
 }

 channel = g_io_channel_unix_new(fd);

 if ((t = time(NULL)) == (time_t)(-1))
  perror("log_to_file:time");

 log_message = g_strdup_printf("%s: %s\n", g_strchomp(ctime(&t)), message);
 (void) file_write_line(channel, log_message);
 g_free(log_message);

 g_io_channel_close(channel);
 g_io_channel_unref(channel);
}

/******************************************************************************
 Log an error, similar to perror().
******************************************************************************/
void log_perror(const gchar *message)
{
 g_warning("%s: %s(%d)", message, g_strerror(errno), errno);
}

