/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* goods.c  --  Functions to handle goods. */


#include "common.h"
#include "towns.h"
#include "transporters.h"

#include "goods.h"


guint number_of_goods;

gchar goodnames[MAX_NUMBER_OF_GOODS][MAX_LEN_GOODNAME+1];


/******************************************************************************
 Create a new good.
******************************************************************************/
good_t *good_new(guint id, glong amount, glong price)
{
 good_t *good = g_malloc(sizeof(good_t));

 good->id = id;
 good->amount = amount;
 good->price = price;

 return good;
}

/******************************************************************************
 Free the memory used by a good.
******************************************************************************/
void good_free(good_t *good)
{
 g_free(good);
}

/******************************************************************************
 Free the memory used by all goods in the list.
******************************************************************************/
void good_free_all(GList *goods)
{
 GList *g;
 good_t *good;

 if ((g = g_list_first(goods)) == NULL)
 {
  g_list_free(goods);
  return; 
 }

 do
 {
  good = g->data;
  good_free(good);
 } while ((g = g_list_next(g)) != NULL);

 g_list_free(goods);
}

/******************************************************************************
 Find the good with the given ID.
******************************************************************************/
good_t *good_find_by_id(GList *goods, guint id)
{
 GList *g;
 good_t *good;

 if ((g = g_list_first(goods)) == NULL)
  return NULL; /* Good not found. */

 do
 {
  good = g->data;

  if (good->id == id)
   return good;

 } while ((g = g_list_next(g)) != NULL);

 return NULL; /* Good not found. */
}

/******************************************************************************
 Return a list of goods which are either in the town or in the transporter.
******************************************************************************/
GList *good_in_town_or_transporter(town_t *town, transporter_t *transporter)
{
 GList *g;
 GList *goods = NULL;
 good_t *good_town, *good_transporter;

 if ((g = g_list_first(town->goods)) == NULL)
  return NULL;

 do
 {   
  good_town = g->data;
  good_transporter = good_find_by_id(transporter->goods, good_town->id);

  if ((good_town->amount != 0) || (good_transporter->amount != 0))
   goods = g_list_append(goods, GUINT_TO_POINTER(good_town->id));

 } while ((g = g_list_next(g)) != NULL);

 return goods;
}

