/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* dialogs.c  --  Generic dialog-routines. */


#include "common.h"
#include "log.h"
#include "nc.h"
#include "net.h"
#include "conf.h"
#include "misc.h"
#include "players.h"
#include "colors.h"
#include "input.h"

#include "dialogs.h"


/******************************************************************************
 ...
******************************************************************************/
void dialog_connect(gchar *hostname, gushort *port)
{
 WINDOW *win = newwin(4, 1+9+MAX_LEN_SERVERNAME+1, 10, 20);
 PANEL *panel = new_panel(win);
 gchar a_string[MAX_LEN_SERVERNAME+1];
 chtype ch;
 gint x, y;
 gint pos = 0;
 gint field = 0;
 gboolean end_loop = NO;
 

 (void) wattron(win, colors.dialog_connect);

 getmaxyx(win, y, x);
 wfillbox(win, 0, 0, x, y, (chtype)' ');

 (void) mvwaddstr(win, 1, 1, "Server: ");
 (void) mvwaddstr(win, 2, 1, "Port: ");

 /* if (host != NULL)
  mvwaddstr(win, 1, 13, host); */

 (void) wmove(win, 1, 9);

 (void) box(win, ACS_VLINE, ACS_HLINE);
 update_panels(); 
 (void) doupdate();

 (void) curs_set(VISIBLE);


 while (end_loop == NO)
 {
  switch ((gint)(ch = input_wait_for_keypress(win)))
  {
   case '\n':            /* fallthrough */
   case '\r':            /* fallthrough */
   case KEY_ENTER:
    switch(field)
    {
     case 0: /* server IP or name */
      strncpy(hostname, a_string, MAX_LEN_SERVERNAME);
      a_string[0] = '\0';
      (void) wmove(win, 2, 7);
      field++;
      pos = 0;
     break;
     case 1: /* port */
      *port = (gushort)strtol(a_string, NULL, 0);
      end_loop = YES;
     break;
    }
   break;

   case 7:               /* fallthrough */
   case 8:               /* fallthrough */
   case KEY_DC:          /* fallthrough */
   case KEY_LEFT:        /* fallthrough */
   case KEY_BACKSPACE:
    if (pos > 0)
    {
     getyx(win, y, x);
     (void) wmove(win, y, x-1);
     (void) waddch(win, (chtype)' ');
     (void) wmove(win, y, x-1);
     pos--;
     a_string[pos] = '\0';
    }
   break;

   default:
    if ((pos < MAX_LEN_SERVERNAME) && ((ch >= 32) && (ch <= 127)))
    {
     a_string[pos + 1] = '\0';
     a_string[pos] = (gchar)ch;
     (void) waddch(win, ch);
     pos++;
    }
   break;

  }

 }

 (void) wattroff(win, colors.dialog_connect);

 (void) curs_set(INVISIBLE);

 (void) del_panel(panel);
 (void) delwin(win);
}

/******************************************************************************
 ...
******************************************************************************/
void dialog_playername_password(gchar *playername, gchar *password,
                                chtype color)
{
 WINDOW *win = newwin(4, 1+12+MAX_LEN_PLAYERNAME+1, 10, 20);
 PANEL *panel = new_panel(win);
 gchar a_string[256];  /* FIXME */
 chtype ch;
 gint x, y;
 gint pos = 0;
 gint field = 0;
 gboolean end_loop = NO;


 (void) wattron(win, color);

 getmaxyx(win, y, x);
 wfillbox(win, 0, 0, x, y, (chtype)' ');

 (void) mvwaddstr(win, 1, 1, "Playername: ");
 (void) mvwaddstr(win, 2, 1, "Password: ");

 /* if (playername != NULL)
  (void) mvwaddstr(win, 1, 13, playername); */

 (void) wmove(win, 1, 13);

 (void) box(win, ACS_VLINE, ACS_HLINE);
 update_panels(); 
 (void) doupdate();

 (void) curs_set(VISIBLE);


 while (end_loop == NO)
 {
  switch ((gint)(ch = input_wait_for_keypress(win)))
  {
   case '\n':            /* fallthrough */
   case '\r':            /* fallthrough */
   case KEY_ENTER:
    switch (field)
    {
     case 0: /* playername */
      strncpy(playername, a_string, MAX_LEN_PLAYERNAME);
      a_string[0] = '\0';
      (void) wmove(win, 2, 11);
      field++;
      pos = 0;
     break;
     case 1: /* password */
      strncpy(password, a_string, MAX_LEN_PLAYERPASSWORD);
      end_loop = YES;
     break;
    }
   break;

   case 7:               /* fallthrough */
   case 8:               /* fallthrough */
   case KEY_DC:          /* fallthrough */
   case KEY_LEFT:        /* fallthrough */
   case KEY_BACKSPACE:
    if ((pos > 0))
    {
     if (field != 1)
     {
      getyx(win, y, x);
      (void) wmove(win, y, x-1);
      (void) waddch(win, (chtype)' ');
      (void) wmove(win, y, x-1);
     }
 
     pos--;
     a_string[pos] = '\0';
    }
   break;

   default:
    if ((pos < MAX_LEN_PLAYERNAME) && ((ch >= 32) && (ch <= 127)))
    {
     a_string[pos + 1] = '\0';
     a_string[pos] = (gchar)ch;
     if (field == 0)
      (void) waddch(win, ch);
     pos++;
    }
   break;

  }
 
 }

 (void) wattroff(win, color);

 (void) curs_set(INVISIBLE);

 (void) del_panel(panel);
 (void) delwin(win);
}

