/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* colors.h  --  Functions to handle colors. */


#ifndef COLORS_H
#define COLORS_H    /* To stop multiple inclusions. */


#include "common.h"


typedef struct colors_t
{
 chtype normal;
 chtype statusbar1;
 chtype statusbar2;
 chtype about_box;
 chtype help_box;
 chtype dialog_connect;
 chtype dialog_addplayer;
 chtype dialog_login;
 chtype buy;
 chtype sell;
 chtype terminal_background;
} colors_t;

extern colors_t colors;

void colors_init(void);
void colors_set_defaults(void);

chtype colors_get_pair(const gchar *fg, const gchar *bg);


#endif /* COLORS_H */

