/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* colors.c  --  Functions to handle colors. */


#include "common.h"

#include "colors.h"


colors_t colors;

/******************************************************************************
 Initialize the colors.
******************************************************************************/
void colors_init(void)
{
 gshort i, j;
 guint counter=0;

 if (has_colors())
 {
  (void) start_color();

  for (i=0; i<7; i++)
   for (j=0; j<7; j++)
    (void) init_pair((gshort)counter++, i, j);
 }
}

/******************************************************************************
 Set default colors.
******************************************************************************/
void colors_set_defaults(void)
{
 colors.normal              = colors_get_pair("white", "black");
 colors.terminal_background = colors_get_pair("black", "black");

 colors.statusbar1          = colors_get_pair("black", "white");
 colors.statusbar2          = colors_get_pair("black", "white");
 colors.about_box           = colors_get_pair("black", "green");
 colors.help_box            = colors_get_pair("black", "green");
 colors.dialog_connect      = colors_get_pair("black", "green");
 colors.dialog_addplayer    = colors_get_pair("black", "green");
 colors.dialog_login        = colors_get_pair("black", "green");
 colors.buy                 = colors_get_pair("black", "green");
 colors.sell                = colors_get_pair("black", "red");
}

/******************************************************************************
 Returns a chtype with the color-pair described by fg and bg.
******************************************************************************/
chtype colors_get_pair(const gchar *fg, const gchar *bg)
{
 chtype color;
 gint i, foreground, background;

 struct mapping_t
 {
  const gchar *name;
  gint value;
 } color_mapping[] =
 {
  { "black",   COLOR_BLACK },
  { "green",   COLOR_GREEN },
  { "red",     COLOR_RED },
  { "cyan",    COLOR_CYAN },
  { "white",   COLOR_WHITE },
  { "magenta", COLOR_MAGENTA },
  { "blue",    COLOR_BLUE },
  { "yellow",  COLOR_YELLOW },
  { NULL,      0 }
 };

 struct mapping_t *iterator;

 for (iterator = color_mapping; iterator->name != NULL; iterator++)
 {
  if (g_strcasecmp(iterator->name, fg) == 0)
   foreground = iterator->value;

  if (g_strcasecmp(iterator->name, bg) == 0)
   background = iterator->value;
 }

 for (i=0; i<COLOR_PAIRS; i++)
 {
  gshort f, b;

  (void) pair_content((gshort)i, (gshort *)&f, (gshort *)&b);

  if ((foreground == f) && (background == b))
   color = COLOR_PAIR(i); 
 }

 return color;
}

