/******************************************************************************
 nhtsclient - a ncurses-based client for the trading game Holsham Traders
 Copyright (C) 1999-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* cmdline.h  --  Commandline-options handling. */


#ifndef CMDLINE_H
#define CMDLINE_H    /* To stop multiple inclusions. */


#include "common.h"


/* The usage message. */
#define USAGE "\
"PACKAGE" "VERSION", Copyright (C) 1999-2001 Uwe Hermann\n\n\
\
"PACKAGE" comes with ABSOLUTELY NO WARRANTY. This is\n\
free software, and you are welcome to redistribute it under the\n\
terms of the GNU General Public License. See COPYING for details.\n\n\
\
Usage: "PACKAGE" [Options]\n\
\n\
 -H, --host=HOSTNAME      Connect to HOSTNAME by default.\n\
 -p, --port=PORT          Connect on the port PORT by default.\n\
 -c, --configfile=FILE    The location of the configfile.\n\
 -l, --logfile=FILE       The location of the logfile.\n\
 -d, --datadir=DIR        The location of the data directory.\n\
 -m, --nomusic            Don't play music.\n\
 -s, --nosound            Don't output sound.\n\
 -h, --help               Show this help.\n\
 -V, --version            Print the version number.\n\
\n\
Report bugs to Uwe Hermann <uh1763@hermann-uwe.de>.\n\n"


struct cmdline_t
{
 gboolean host;
 gboolean port;
 gboolean music;
 gboolean sound;
 gboolean configfile;
 gboolean logfile;
 gboolean datadir;
};

typedef struct cmdline_t cmdline_t;

extern cmdline_t cmdline;

void parse_arguments(gint argc, gchar *argv[]);


#endif /* CMDLINE_H */

