/* a simple world map file */
map 21 20	/* size */
    200.0	/* ground size */
    1200	/* max hill height */
{
DSAGKADSKGLHDGKSHGDKA
DFBABCBAAAAABCBAAAKLA
KAAAAAAAAAAAAAAAAAAMA
NAAAAAAAAAAAAAAAAAAPA
LAAAAAAAAAAAAAAAAAANA
NAAAAAAAAAAAAAAAAAAPA
ZDBAAAAAAAAAAAAAAABQA
PAAAAAAAAAAAAAAAAAANA
NAAAAAAAAAAAAAAAAAAMA
OAAAAAAAAAAAAAAAAAALA
PAAAAAAAAGGAAAAAAAANA
NAAAAAAAAAAAAAAAAAAMA
AAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAA
AAJGJKGJKJKAAAAAAAAAA
AAAjjjkfuJLKAAAAAAAAA
AAAJHGJJGJJAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAA
}

lookout 815 915 130
fadeto 22000 22000 22000 
ground 2 2

#include "house.def.v"
#define House(x,y)	vehicle HOUSE { \
			instance house \
			offset x y 0 \
			}

vehicle pylon def { 
name "A power pole" 
type static 
hp 6 
object { 
	at x y 0 
	points { 0 0 0  3 0 0  3 3 0  0 3 0 
		 0 0 25  3 0 25  3 3 25  0 3 25 
		} 
	face 170 f { 0 4 5 1 }
	face 171 f { 1 5 6 2 } 
	face 172 f { 2 6 7 3 } 
	face 173 f { 3 7 4 0 } 
	face 174 f { 7 6 5 4 } 
	} 
object { 
	at x y 0 
	points { 0 -4 22  0 7 22 } 
	face 32 l { 0 1 } 
	} 
object {
	at x y 0
	points { 3 -4 22  3 7 22 }
	face 32 l { 0 1 }
	}
}
#define Pylon(x,y)	vehicle PYLON { \
			instance pylon \
			offset x y 0 \
			}

#define RoadN(x,y)	object { \
				at x y 0 \
				points { 0 0 0  200 0 0  200 40 0  0 40 0 } \
				face 45 p { 0 1 2 3 } \
				} 

#define RoadE(x,y)	object { \
				at x y 0 \
				points { 0 0 0  0 200 0  40 200 0  40 0 0 } \
				face 45 p { 0 1 2 3 } \
				} 

vehicle house2 def { 
name "A fairly large house" 
type static 
hp 35 
object { 
	at x y 0 
	points { 
		0 0 0  80 0 0  80 40 0  0 40 0 
		0 0 20  80 0 20  80 40 20  0 40 20 
		20 20 30  60 20 30 
		} 
	face 140 f { 0 4 5 1 } 
	face 141 f { 1 5 6 2 } 
	face 142 f { 2 6 7 3 } 
	face 143 f { 3 7 4 0 } 
	face 50 f { 4 8 9 5 } 
	face 51 f { 5 9 6 } 
	face 52 f { 6 9 8 7 } 
	face 53 f { 7 8 4 } 
	} 
}

#define House2(x,y)	vehicle HOUSE2 { \
			instance house2 \
			offset x y 0 \
			}

vehicle tower def {
name "A 10 storey building"
type static
hp 66
object {		/* Lower part */
	points {
		0 0 0  50 0 0  50 50 0  0 50 0
		0 0 80  50 0 80  50 50 80  0 50 80
		}
	face 50 f { 0 4 5 1 }
	face 51 f { 1 5 6 2 }
	face 52 f { 2 6 7 3 }
	face 53 f { 3 7 4 0 }
	face 54 f { 7 6 5 4 }
	}
object {		/* Middle section */
	points {
		10 10 80  40 10 80  40 40 80  10 40 80
		10 10 200  40 10 200 40 40 200  10 40 200
		}
	face 55 f { 0 4 5 1 }
	face 56 f { 1 5 6 2 }
	face 57 f { 2 6 7 3 }
	face 58 f { 3 7 4 0 }
	face 59 f { 7 6 5 4 }
	}
object {		/* Pointed top bit */
	points {
		15 15 200  35 15 200  35 35 200  15 35 200  25 25 300
		}
	face 60 f { 0 4 1 }
	face 61 f { 1 4 2 }
	face 62 f { 2 4 3 }
	face 63 f { 3 4 0 }
	}
object {		/* aerial on top */
	points { 25 25 300  25 25 330 }
	face 255 l { 0 1 }
	}
}

#define Tower(x,y)	vehicle TOWER { \
			instance tower \
			offset x y 0 \
			}

#define Tree(x,y)	vehicle TREE { \
			instance tree \
			offset x y 0 \
			}

/* Houses in the corner of the map */
House(700,700)
House(760,700)
House(820,700)
House(880,700)
House(700,780)
House2(760,780)

/* the road between villages */
vehicle road {
name "The road between villages"
type scenery
RoadN(700,740)
RoadN(900,740)
RoadN(1100,740)
RoadN(1300,740)
RoadN(1500,740)
RoadN(1700,740)
RoadN(1900,740)
RoadN(2100,740)
RoadN(2300,740)
RoadN(2500,740)
RoadN(2700,740)
RoadN(2900,740)
object {				/* with a helipad at the end */
	points { 3100 700 0  3220 700 0  3220 820 0  3100 820 0 }
	face 45 p { 0 1 2 3 }
	}
}

/* power poles along the north-south road */
Pylon(960,737)
Pylon(960,780)
Pylon(1160,737)
Pylon(1160,780)	
Pylon(1360,737)
Pylon(1360,780)	

/* the east-west road */
vehicle road2 {
name "The East-West Road"
type scenery
RoadE(1700,500)
RoadE(1700,700)
RoadE(1700,900)
RoadE(1700,1100)
}

/* a house at the end of the road */
House(1700,1300)

/* houses at the intersection */
House(1740,700)
House2(1740,780)
House(1660,700)

vehicle church {
name "A Church Building with tower"
type static
hp 100
offset 800 900 0
object {		/* the tower */
	at 0 0 0 
	points { 
		0 0 0  30 0 0  30 30 0  0 30 0 
		0 0 90  30 0 90  30 30 90  0 30 90 
		15 15 120
		}
        face 50 f { 0 4 5 1 }
        face 51 f { 1 5 6 2 }
 	face 52 f { 2 6 7 3 }
        face 53 f { 3 7 4 0 }
        face 174 f { 4 8 5 }
	face 175 f { 5 8 6 }
        face 176 f { 6 8 7 }
	face 177 f { 7 8 4 } 
	}
}
House2(831,900)

vehicle road3 {
name "The road from the village to tower"
type scenery
RoadE(910,780)
}

/* another village */
House(2800,3000)
House(2800,3100)
House(2880,3050)
House2(2880,3130)
vehicle road4 {
name "A long long road"
type scenery
RoadE(2840,3000)
RoadE(2840,2800)
RoadE(2840,2600)
RoadE(2840,2400)
RoadE(2840,2200)
RoadE(2840,2000)
RoadE(2840,1800)
RoadE(2840,1600)
RoadE(2840,1400)
RoadE(2840,1200)
RoadE(2840,1000)
RoadE(2840,800)
RoadE(2840,600)
}

/* Some trees */
Tree(1502,1002)
Tree(1515,1060)
Tree(2150,1486)
Tree(1081,1080)
Tree(1590,1801)
Tree(1933,1052)
Tree(1560,1010)
Tree(2581,1243)
Tree(1820,1030)
Tree(1201,1096)
Tree(2315,1638)
Tree(1500,1064)

/* A few large buildings */
Tower(3200,3800)
Tower(3290,3800)
Tower(3200,3870)
Tower(3290,3920)

/* Ammuniton and weapons bonuses */
vehicle missilebonus {
name "A Missile Launcher"
flying
type weapon
weapon missile
hp 2
offset 3100 3700 2
object {
	points { 0 0 0  5 0 0  5 5 0  0 5 0
		 0 0 5  5 0 5  5 5 5  0 5 5 }
	face 25 f { 0 4 5 1 }
	face 26 f { 1 5 6 2 }
	face 27 f { 2 6 7 3 }
	face 28 f { 3 7 4 0 }
	face 29 f { 0 1 2 3 }
	face 30 f { 7 6 5 4 }
	}
}

/* A road between them the towers */
vehicle road {
name "The city road"
type scenery
RoadE(3250,4000)		/* through city */
RoadE(3250,3800)
RoadE(3250,3600)
RoadE(3250,3400)
RoadE(3250,3200)
RoadN(2650,3200)		/* connecting to other road */
RoadN(2850,3200)
RoadN(3050,3200)
}

/* things living in the game world */
#include "ptero.def.v"
#include "amigaball.def.v"
#include "fish.def.v"
vehicle fish {
instance fish
offset 600 600 200
}

vehicle amigaball {
instance amigaball
offset 1220 760 0
}

vehicle ptero2 {
instance pterodactyl
offset 1200 1100 160
}

vehicle ptero3 {
instance pterodactyl
offset 1000 1000 240
}

