/* command.c
 *
 * functions used by server to communicate with client
 */

#include "net3d.h"

int stillalive;

/* Read a line from each client, and re-transmit them to all clients
 */
void processnet(int psocks[], int plcount, int mainsock)
{
char clcom[400];			/* message to send to clients */
char *msg;				/* message from client */
static Bool dead[MAX_PLAYERS] = {0};	/* list of who's dead */
int i;					/* loop counter */

/* start broadcast with game time, followed by concatenation of 
 * messages from clients.
 */
sprintf(clcom,"%f",gametime());
for(i=0; i<plcount; i++) {
	msg=ngets(psocks[i]);
#if NETDEBUG
		printf("recieved \"%s\" from player %d\n",msg,i);
#endif
	if (msg[0] == 'd' && !dead[i]) {
		/* client has declared that it's player is dead.
		 */
		dead[i] = True;
		stillalive--;
		if (stillalive==1) {
			/* Tell all clients that only one player is left. */ 
			strcat(clcom," w 0 0.0");
			printf("we have a winner..\n");
			}
		}
	else {
		if (strlen(msg)) {
			strcat(clcom," ");
			strcat(clcom,msg);
			}
		}
	}

/* send broadcast message to all clients */
#if NETDEBUG
	printf("sending \"%s\" to clients\n",clcom);
#endif

for(i=0; i<plcount; i++)
	nprintf(psocks[i],"%s\n",clcom);
}

