/******************************************************************************
 htsserver - the server application for the trading game Holsham Traders
 Copyright (C) 1998-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* trade.c  --  Trading routines. */


#include "common.h"
#include "towns.h"
#include "goods.h"
#include "transporters.h"
#include "servercmds.h"

#include "trade.h"


/******************************************************************************
 Buy goods from a town and store them in a transporter.
******************************************************************************/
gint trade_buy_from_town_to_transporter(transporter_t *transporter, guint what,
                                        glong amount)
{
 town_t *town = town_find_by_id(transporter->location);
 good_t *town_good = good_find_by_id(town->goods, what);
 good_t *transporter_good = good_find_by_id(transporter->goods, what);


 /* Check whether town has got the requested amount of the good. */
 if (town_good->amount < amount)
  return -2;

 /* Check whether the transporter has enough free capacity. */
 if (transporter_free_capacity(transporter) < amount)
  return -3;

 /* Check whether the transporter has enough money. */
 if (transporter->money < (amount * town_good->price))
  return -4;


 /* Transfer goods. */
 town_good->amount -= amount;
 transporter_good->amount += amount;

 /* Transfer money. */
 town->money += amount * town_good->price;
 transporter->money -= amount * town_good->price;

 /* TODO Re-calculate price of the good. */

 return 0;
}

/******************************************************************************
 Sell goods from a transporter to a town.
******************************************************************************/
gint trade_sell_from_transporter_to_town(transporter_t *transporter,
                                         guint what, glong amount)
{
 town_t *town = town_find_by_id(transporter->location);
 good_t *town_good = good_find_by_id(town->goods, what);
 good_t *transporter_good = good_find_by_id(transporter->goods, what);


 /* Check whether the transporter has enough goods. */
 if (transporter_good->amount < amount)
  return -2;

 /* Check whether the town has enough money. */
 if (town->money < (amount * town_good->price))
  return -3;

 /* Check whether town has enough free capacity. */
 /* TODO ??? */


 /* Transfer goods. */
 town_good->amount += amount;
 transporter_good->amount -= amount;

 /* Transfer money. */
 town->money -= amount * town_good->price;
 transporter->money += amount * town_good->price;

 /* TODO Re-calculate price of the good. */

 return 0;
}

