/******************************************************************************
 htsserver - the server application for the trading game Holsham Traders
 Copyright (C) 1998-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* servercmds.h  --  Commands sent by the server. */

#ifndef SERVERCMDS_H
#define SERVERCMDS_H    /* To stop multiple inclusions. */


#include "common.h"
#include "connections.h"
#include "towns.h"
#include "goods.h"


void send_init_data(connection_t *connection);

void send_good_amount_update(player_t *player, town_t *town, good_t *good);
void send_good_price_update(player_t *player, town_t *town, good_t *good);

void send_town_info(connection_t *connection, town_t *town);

void send_player_new(player_t *player);
void send_player_remove(player_t *player);
void send_player_logged_in(player_t *player);
void send_player_logged_out(player_t *player);

void send_pause(player_t *player);
void send_continue(player_t *player);

void send_shutdown(connection_t *connection);

void send_login_timeout(connection_t *connection);

void send_chat_message(guint sender, GList *player_list, const gchar *message);

void send_transporter_arrived(player_t *player, town_t *town,
                              guint transporter_id);
void send_transporter_left(player_t *player, town_t *town,
                           guint transporter_id);


#endif /* SERVERCMDS_H */

