/******************************************************************************
 htsserver - the server application for the trading game Holsham Traders
 Copyright (C) 1998-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* players.h  --  Functions to handle players. */


#ifndef PLAYERS_H
#define PLAYERS_H    /* To stop multiple inclusions. */


#include "common.h"


#define MAX_LEN_PLAYERNAME     30
#define MAX_LEN_PLAYERPASSWORD 80
#define MAX_LEN_ADMINPASSWORD  80

/* Initial values for info about player. */
#define START_AGE   19
#define START_MONEY 800

struct player_t
{
 guint id;
 gchar name[MAX_LEN_PLAYERNAME+1];
 gchar password[MAX_LEN_PLAYERPASSWORD+1];
 gboolean logged_in;
 guint age;
 glong money;
 GList *transporters;
 GList *warehouses;
};

typedef struct player_t player_t;

#include "transporters.h"
#include "towns.h"

extern GList *players;

player_t *player_new(const gchar *name, const gchar *password,
                     gboolean logged_in, guint age, glong money,
                     GList *transporters, GList *warehouses);
void player_free(player_t *player);
void player_free_all(void);

void player_add(player_t *player);
void player_remove(player_t *player);
void player_add_transporter(player_t *player, transporter_t *transporter);
void player_remove_transporter(player_t *player, transporter_t *transporter);

player_t *player_find_by_id(guint id);
player_t *player_find_by_name(const gchar *playername);

gboolean player_exists(const gchar *playername);
gboolean player_has_valid_password(player_t *player, const gchar *password);
gboolean player_has_valid_name(const gchar *playername);

GList *player_with_transporters_in_same_town(player_t *my_player, town_t *town);
GList *player_all_except_this_one(player_t *player);

#endif /* PLAYERS_H */

