/******************************************************************************
 htsserver - the server application for the trading game Holsham Traders
 Copyright (C) 1998-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* htsserver.c  --  Main source file for htsserver. */


#include "common.h"
#include "misc.h"
#include "cmdline.h"
#include "net.h"
#include "log.h"
#include "file.h"
#include "conf.h"
#include "goods.h"
#include "towns.h"
#include "defaults.h"

#include "htsserver.h"


/******************************************************************************
 The main function.
******************************************************************************/
gint main(gint argc, gchar *argv[])
{
 conf_init();

 parse_arguments(argc, argv);

 if (conf_parse() < 0)
 {
  g_printerr("Error parsing configuration file. Using default values.\n");
  conf_init();
 }

 if (strncmp(conf.adminpassword, DEFAULT_ADMINPASSWORD,
             MAX_LEN_ADMINPASSWORD) == 0)
 {
  g_printerr("\
The default adminpassword is used! This is *not* good.\n\
Please change the adminpassword in the configfile. Aborting now.\n\n\
Location of the configfile: %s\n\n", conf.configfile);
  exit(EXIT_FAILURE);
 }

 if (good_read_names() < 0)
  g_error("Error reading goodnames.");

 setup_signal_handling();

 log_init();

 daemonize();

 g_message("htsserver %s started (PID=%d, PORT=%d).", VERSION, getpid(),
           conf.port);

 /* TODO Find a good place for this. */
 if (town_new_all() < 0)
 {
  g_warning("Error creating towns. Aborting");
  exit(EXIT_FAILURE);
 }

 town_add_goods_at_beginning_of_game();

 net_main_loop();

 town_free_all();

 return EXIT_SUCCESS;
}

