/******************************************************************************
 htsserver - the server application for the trading game Holsham Traders
 Copyright (C) 1998-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* defaults.h  --  Compile-time options of htsserver. */


#ifndef DEFAULTS_H
#define DEFAULTS_H    /* To stop multiple inclusions. */


#include "common.h"


/* Default port number the server will listen on. */
#define DEFAULT_PORT 1919

/* Default logging-destination. 0=file, 1=syslog, 2=none.
   If you choose '2' logging will be disabled. */
#define DEFAULT_LOGDEST 0

/* Auto-save delay in seconds. Set to 0 to disable auto-save. */
#define DEFAULT_AUTOSAVE_DELAY 60

/* Login-timeout in seconds. After 'DEFAULT_LOGIN_TIMEOUT' seconds, a client
   who is connected but not logged in, is kicked from the server. Set to 0 to
   disable this. */
#define DEFAULT_LOGIN_TIMEOUT 60

/* Default admin password. You are strongly advised to change this! */
#define DEFAULT_ADMINPASSWORD "foobar"


#endif /* DEFAULTS_H */

