/******************************************************************************
 htsserver - the server application for the trading game Holsham Traders
 Copyright (C) 1998-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* connections.h  --  Functions to handle connections. */


#ifndef CONNECTIONS_H
#define CONNECTIONS_H    /* To stop multiple inclusions. */


#include "common.h"
#include "players.h"


#define NO_PLAYER NULL

struct connection_t
{
 struct sockaddr_in addr;
 player_t *pl;            /* The player this client is logged in as. */
 gboolean is_admin;
 time_t connect_time;
 GIOChannel *channel;
 guint event_source_id;
};

typedef struct connection_t connection_t;

extern GList *connections;

connection_t *connection_new(void);
void connection_free(connection_t *connection);

void connection_add(connection_t *connection);
void connection_remove(connection_t *connection);

gboolean connection_accept(GIOChannel *source, GIOCondition condition,
                           gpointer data);

void connection_close(connection_t *connection);

connection_t *connection_find_by_channel(GIOChannel *channel);
connection_t *connection_find_by_player(player_t *player);
connection_t *connection_find_by_playername(const gchar *playername);

GList *connection_all_except_this_one(connection_t *connection);

gboolean logged_in(connection_t *connection);
gboolean logged_in_as_admin(connection_t *connection);


#endif /* CONNECTIONS_H */

