/******************************************************************************
 htsserver - the server application for the trading game Holsham Traders
 Copyright (C) 1998-2001 Uwe Hermann

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* cmdline.h  --  Commandline-options handling. */


#ifndef CMDLINE_H
#define CMDLINE_H    /* To stop multiple inclusions. */


#include "common.h"


/* The usage message. */
#define USAGE "\
"PACKAGE" "VERSION", Copyright (C) 1998-2001 Uwe Hermann\n\n\
\
"PACKAGE" comes with ABSOLUTELY NO WARRANTY. This is free software,\n\
and you are welcome to redistribute it under the terms of\n\
the GNU General Public License. See COPYING for details.\n\n\
\
Usage: "PACKAGE" [Options]\n\n\
 -p, --port=PORT             Listen for clients on port PORT.\n\
 -D, --logdest=DEST          Log to DEST (file, syslog or none).\n\
 -c, --configfile=FILE       Location of the configfile.\n\
 -l, --logfile=FILE          Location of the logfile.\n\
 -d, --datadir=DIR           Location of the data directory.\n\
 -s, --savegamesdir=DIR      Location of the savegames directory.\n\
 -h, --help                  Show this help.\n\
 -V, --version               Print the version number.\n\
\n\
Report bugs to Uwe Hermann <uh1763@hermann-uwe.de>.\n\n"


struct cmdline_t
{
 gboolean port;
 gboolean logdest;
 gboolean autosave_delay;
 gboolean login_timeout;
 gboolean configfile;
 gboolean logfile;
 gboolean datadir;
 gboolean savegamesdir;
 gboolean adminpassword;
};

typedef struct cmdline_t cmdline_t;

extern cmdline_t cmdline;

void parse_arguments(gint argc, gchar *argv[]);


#endif /* CMDLINE_H */

