/* htclient.ncurses - a ncurses-based client for the game Holsham Traders
   Copyright (C) 1999 Uwe Hermann

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* sock.h  --  header file of sock.c */


#ifndef SOCK_H
#define SOCK_H    /* To stop multiple inclusions. */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "config.h"

extern socklen_t server_port;

int create_socket(void);
void close_socket(int sockfd);
void init_sockaddr(struct sockaddr_in *some_addr, socklen_t some_port);
void connect_to_socket(int sockfd, struct sockaddr_in *some_addr);
void recv_exact(int sockfd, char *buf, size_t size);
void send_exact(int sockfd, char *buf, size_t size);


#endif /* SOCK_H */

