/* htclient.ncurses - a ncurses-based client for the game Holsham Traders
   Copyright (C) 1999 Uwe Hermann

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* sock.c  --  socket-related code */

#include "sock.h"

socklen_t server_port = PORT_NUMBER;

/******************************************************************************
 Create an internet stream socket and return its descriptor.
******************************************************************************/
int create_socket(void)
{
 int sockfd;

 if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
 {
  perror("socket");
  exit(EXIT_FAILURE);
 }
 return sockfd;
}

/******************************************************************************
 Close the socket sockfd.
******************************************************************************/
void close_socket(int sockfd)
{
 if (close(sockfd) < 0)
 {
  perror("close");
  exit(EXIT_FAILURE);
 }
}

/******************************************************************************
 Initialize the sockaddr_in struct of the client.
******************************************************************************/
void init_sockaddr(struct sockaddr_in *some_addr, socklen_t some_port)
{
 memset(some_addr, 0, sizeof(*some_addr));
 some_addr->sin_family = AF_INET;
 some_addr->sin_port = htons((unsigned short int)some_port);
 some_addr->sin_addr.s_addr = inet_addr("127.0.0.1"); /*ip of the server*/
}

/******************************************************************************
 Connect() to a socket.
******************************************************************************/
void connect_to_socket(int sockfd, struct sockaddr_in *some_addr)
{
 if (connect(sockfd, some_addr, (socklen_t)sizeof(*some_addr)) < 0)
 {
  perror("connect");
  close_socket(sockfd);
  exit(EXIT_FAILURE);
 }
}

/******************************************************************************
 Receive exactly size bytes from sockfd.
******************************************************************************/
void recv_exact(int sockfd, char *buf, size_t size)
{
 int gotten;

 do
 {
  if ((gotten = recv(sockfd, buf, size, 0)) < 0)
  {
   perror("recv");
   close_socket(sockfd);
   exit(EXIT_FAILURE);
  }
  buf += gotten;
  size -= gotten;
 } while (size > 0);
 
 buf[size] = '\0';
}

/******************************************************************************
 Send exactly size bytes to sockfd.
******************************************************************************/
void send_exact(int sockfd, char *buf, size_t size)
{
 int sent;

 do
 {
  if ((sent = send(sockfd, buf, size, 0)) < 0)
  {
   perror("send");
   close_socket(sockfd);
   exit(EXIT_FAILURE);
  }
  buf += sent;
  size -= sent;
 } while (size > 0);
}

