/* htclient.ncurses - a ncurses-based client for the game Holsham Traders
   Copyright (C) 1999 Uwe Hermann

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* ncurses.h  --  header file of ncurses.c */


#ifndef NCURSES_H
#define NCURSES_H    /* To stop multiple inclusions. */


/*#include <ncurses.h>*/
#include <curses.h>
#include <signal.h>

#define SIZE_OF_YOUR_GOODS 6   /*?*/
#define SIZE_OF_GOODNAME 12
#define SIZE_OF_PRICE 6
#define SIZE_OF_GOODS_IN_TOWN 6
#define SIZE_OF_GOODS_IN_TRANSPORTER 6

#define HEIGHT_OF_TABLE 13
#define WIDTH_OF_TABLE SIZE_OF_GOODNAME+1 + SIZE_OF_PRICE+1 + SIZE_OF_GOODS_IN_TOWN+1 + SIZE_OF_GOODS_IN_TRANSPORTER+1

#define UP 0                    /*these two indicate the scroll direction*/
#define DOWN 1

/*TRADE_WIN = the list of goods with the respective amount/prices*/
#define TRADE_WIN_STARTX 1
#define TRADE_WIN_STARTY 1
#define TRADE_WIN_XSIZE WIDTH_OF_TABLE+1
#define TRADE_WIN_YSIZE HEIGHT_OF_TABLE+1

/*INPUT_WIN = where you key in the amount of goods, you want to buy/sell*/
#define INPUT_WIN_STARTX 30
#define INPUT_WIN_STARTY 10
#define INPUT_WIN_XSIZE 10
#define INPUT_WIN_YSIZE 3

/*log window*/
#define LOG_WIN_XSIZE 78
#define LOG_WIN_YSIZE 7
#define LOG_WIN_STARTX 1
#define LOG_WIN_STARTY 16

/*status window*/
#define STATUS_WIN_XSIZE 30
#define STATUS_WIN_YSIZE 10
#define STATUS_WIN_STARTX 40
#define STATUS_WIN_STARTY 1

/*for curs_set()*/
#define INVISIBLE 0
#define VISIBLE 1
#define VERYVISIBLE 2

#define HIGHLITE_GREEN 0
#define HIGHLITE_RED 1
#define HIGHLITE_WHITE 2

void ncurses_init(void);
static void finish(int sig);        /* reset terminal after ncurses quits */

/*
WINDOW *trade_win;
WINDOW *input_win;
WINDOW *log_win;
WINDOW *status_win;

extern void display_main_screen();
extern void init_highlite_good(WINDOW *some_win);
extern void init_log();
extern void start_loop();
*/



#endif /* NCURSES_H */

