/* htclient.ncurses - a ncurses-based client for the game Holsham Traders
   Copyright (C) 1999 Uwe Hermann

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* ncurses.c  --  ncurses-related code */

#include "ncurses.h"


/*****************************************************************************/
void ncurses_init(void)
{

 if (signal(SIGINT, finish) == SIG_IGN)   /* install signal-handler */
 {
  (void) signal(SIGINT, SIG_IGN);
 }


 (void) initscr();      /* initialize the curses library */
 (void) keypad(stdscr, TRUE);  /* enable keyboard mapping */
 (void) nonl();         /* tell curses not to do NL->CR/NL on output */
 (void) cbreak();       /* take input chars one at a time, no wait for \n */
 (void) noecho();       /* don't echo input */

 (void) curs_set(INVISIBLE);   /* cursor is invisible now */



 if (has_colors())
 {
  (void) start_color();
  (void) init_pair(COLOR_BLACK, COLOR_BLACK, COLOR_BLACK);
  (void) init_pair(COLOR_GREEN, COLOR_GREEN, COLOR_BLACK);
  (void) init_pair(COLOR_RED, COLOR_RED, COLOR_BLACK);
  (void) init_pair(COLOR_CYAN, COLOR_CYAN, COLOR_BLACK);
  (void) init_pair(COLOR_WHITE, COLOR_WHITE, COLOR_BLACK);
  (void) init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_BLACK);
  (void) init_pair(COLOR_BLUE, COLOR_BLUE, COLOR_BLACK);
  (void) init_pair(COLOR_YELLOW, COLOR_YELLOW, COLOR_BLACK);
 }

 /*create new window(s)*/
/*
 trade_win = newwin(TRADE_WIN_YSIZE, TRADE_WIN_XSIZE, TRADE_WIN_STARTY, TRADE_WIN_STARTX);

 input_win = newwin(INPUT_WIN_YSIZE, INPUT_WIN_XSIZE, INPUT_WIN_STARTY, INPUT_WIN_STARTX);

 log_win = newwin(LOG_WIN_YSIZE, LOG_WIN_XSIZE, LOG_WIN_STARTY, LOG_WIN_STARTX);
 status_win = newwin(STATUS_WIN_YSIZE, STATUS_WIN_XSIZE, STATUS_WIN_STARTY, STATUS_WIN_STARTX);

 display_main_screen();
 init_highlite_good(trade_win);
 init_log();

 wattron(input_win, COLOR_PAIR(COLOR_WHITE));*/
/* wattron(status_win, COLOR_PAIR(COLOR_WHITE));*/ /*done in init_status()*/

 /*start_loop();*/

 /*main_menu();*/

 finish(0);

}

/*****************************************************************************/
static void finish(int sig)
{
 (void) endwin();
}

