/* htclient.ncurses - a ncurses-based client for the game Holsham Traders
   Copyright (C) 1999 Uwe Hermann

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* log.c  --  stderr/syslog/file-logging */

#include "log.h"

int verbosity_level = HTSLOG_ERROR;    /* default: log only errors */

/******************************************************************************
 Generic log-routine. Can log to stderr, syslog or a file.
 Has four different log-level: none, error, info and debug.
******************************************************************************/
void htslog(int log_type, int log_level, char *some_message)
{
 switch(log_type)
 {

  case HTSLOG_FILE:
   /* TODO */
  break;

  case HTSLOG_SYSLOG: 
   switch(log_level)
   {
    case HTSLOG_ERROR:
     if (verbosity_level >= HTSLOG_ERROR)
     {
      openlog("htsclient.ncurses", LOG_PID, LOG_USER);
      syslog(LOG_USER|LOG_ERR, "%s", some_message);
      closelog();
     }
    break;
    case HTSLOG_INFO:
     if (verbosity_level >= HTSLOG_INFO)
     {
      openlog("htsclient.ncurses", LOG_PID, LOG_USER);
      syslog(LOG_USER|LOG_INFO, "%s", some_message);
      closelog();
     }
    break;
    case HTSLOG_DEBUG:
     if (verbosity_level == HTSLOG_DEBUG)
     {
      openlog("htsclient.ncurses", LOG_PID, LOG_USER);
      syslog(LOG_USER|LOG_DEBUG, "%s", some_message);
      closelog();
     }
    break;
   }
  break;

  case HTSLOG_STDERR:
   switch(log_level)
   {
    case HTSLOG_ERROR:
     if (verbosity_level >= HTSLOG_ERROR)
      fprintf(stderr, "htsclient.ncurses ERROR: %s\n", some_message);
    break;
    case HTSLOG_INFO:
     if (verbosity_level >= HTSLOG_INFO)
      fprintf(stderr, "htsclient.ncurses INFO: %s\n", some_message);
    break;
    case HTSLOG_DEBUG:
     if (verbosity_level == HTSLOG_DEBUG)
      fprintf(stderr, "htsclient.ncurses DEBUG: %s\n", some_message);
    break;
   }
  break;
 }

}
