/* htclient.ncurses - a ncurses-based client for the game Holsham Traders
   Copyright (C) 1999 Uwe Hermann

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* cmdline.c  --  commandline-options handling */

#include "cmdline.h"


/*****************************************************************************/
static void help(void)
{
 printf("htsclient.ncurses %s, Copyright (C) 1999 Uwe Hermann\n\n", VERSION);
 printf("htsclient.ncurses comes with ABSOLUTELY NO WARRANTY. This is\n");
 printf("free software, and you are welcome to redistribute it under the\n");
 printf("terms of the GNU General Public License. See COPYING for details.\n");

 printf("\nUsage: htsclient.ncurses [-pvhV] [--port=PORT] [--verbosity=LEVEL] [--help]\n       [--version]\n\n");
 printf(" -p, --port=PORT           try to connect to port 'PORT' instead\n");
 printf("                           of the default port\n");
 printf(" -v, --verbosity=LEVEL     set verbosity level to 'LEVEL'. Possible values\n");
 printf("                           range from 0(no verbosity) to 3(maximum verbosity).\n");
 printf(" -h, --help                show this help and exit\n");
 printf(" -V, --version             output version information and exit\n\n");
 exit(EXIT_SUCCESS);
}

/*****************************************************************************/
static void print_version(void)
{
 printf("%s\n", VERSION);
 exit(EXIT_SUCCESS);
}

/*****************************************************************************/
/* the framework for this code is ripped from the getopt_long() manpage */
void parse_arguments(int argc, char *argv[])
{
 int i, c, tmp;

 while(1)
 {
  int option_index = 0;
  static struct option long_options[] =
  {
   {"port", required_argument, NULL, (int)'p'},
   {"verbosity", required_argument, NULL, (int)'v'},
   {"help", no_argument, NULL, (int)'h'},
   {"version", no_argument, NULL, (int)'V'},
   {0, 0, 0, 0}
  };
 
  c = getopt_long(argc, argv, "p:v:hV", long_options, &option_index);

  if (c == -1) break;

  switch(c)
  {
   /* TODO check for bugs! This is a hack. */

   /**************************************************************************/
   case 'p':
    tmp = (int)strlen(optarg);

    for (i=0;i<tmp;i++)
    {
     if (!(isdigit((int)*(optarg+i))))       /* hope this really works :-) */
     {
      htslog(HTSLOG_STDERR, HTSLOG_ERROR, "The specified port is illegal.");
      exit(EXIT_FAILURE);
     }
    }

    errno = 0;
    server_port = (socklen_t)strtol(optarg, NULL, 0);

    if (errno != 0)
    {
     htslog(HTSLOG_STDERR, HTSLOG_ERROR, "The specified port is illegal.");
     exit(EXIT_FAILURE);
    }
   break;

   /**************************************************************************/
   case 'v':
    tmp = (int)*optarg;

    if (isdigit(tmp) && (tmp>=(int)'0') && (tmp<=(int)'3') && ((int)strlen(optarg) == 1))
     verbosity_level = (int)strtol(optarg, NULL, 0);
    else
    {
     htslog(HTSLOG_STDERR, HTSLOG_ERROR,
     "Verbosity-level must be either 0, 1, 2 or 3.");
     exit(EXIT_FAILURE);
    }
   break;

   /**************************************************************************/
   case 'h': help(); break;

   /**************************************************************************/
   case 'V': print_version(); break;

   /**************************************************************************/
   case '?': exit(EXIT_FAILURE); break;
  }

 }
}


