/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* statusbar.c  --  code for the statusbar */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include "log.h"
#include "protocol.h"
#include "net.h"
#include "mainwin.h"
#include "logindialog.h"
#include "about.h"
#include "data.h"
#include "messagedialog.h"

#include "statusbar.h"


#define CONNECT0_XPM ""GHTSCLIENT_DATADIR"/holsham/graphics/connect0.xpm"
#define CONNECT1_XPM ""GHTSCLIENT_DATADIR"/holsham/graphics/connect1.xpm"

#define LOGIN0_XPM ""GHTSCLIENT_DATADIR"/holsham/graphics/login0.xpm"
#define LOGIN1_XPM ""GHTSCLIENT_DATADIR"/holsham/graphics/login1.xpm"

GtkWidget *statbar;
GtkWidget *wdg_login;
GtkWidget *wdg_connect;

/*****************************************************************************/
void ghts_statusbar(GtkWidget *window, GtkBox *some_box)
{
 GdkPixmap *pixmap;
 /*GdkBitmap *mask;*/
 /*GtkStyle *style;*/
 /*GtkWidget *pixmapwid;*/

 statbar = gtk_hbox_new(FALSE, 1);

 gtk_box_pack_end(GTK_BOX(some_box), statbar, FALSE, FALSE, 0);

/*****************************************************************************/

 /*style = gtk_widget_get_style(window);*/

 pixmap = gdk_pixmap_create_from_xpm(statbar->window, NULL/*&mask*/,
                                     NULL/*&style->bg[GTK_STATE_NORMAL]*/,
                                     CONNECT0_XPM);
 wdg_connect = gtk_pixmap_new(pixmap, NULL/*mask*/);

 gtk_box_pack_start(GTK_BOX(statbar), wdg_connect, FALSE, FALSE, 3);

 gtk_widget_show(wdg_connect);

/*****************************************************************************/

 /*style = gtk_widget_get_style(window);*/

 pixmap = gdk_pixmap_create_from_xpm(statbar->window, NULL/*&mask*/,
                                     NULL/*&style->bg[GTK_STATE_NORMAL]*/,
                                     LOGIN0_XPM);
 wdg_login = gtk_pixmap_new(pixmap, NULL/*mask*/);

 gtk_box_pack_start(GTK_BOX(statbar), wdg_login, FALSE, FALSE, 3);

 gtk_widget_show(wdg_login);

/*****************************************************************************/

 gtk_widget_show(statbar);

 ghtslog(GHTSLOG_DEBUG, "Creating statusbar.");
}

/*****************************************************************************/
void ghts_update_statusbar(void)
{
 GdkPixmap *pixmap;

 gtk_widget_destroy(wdg_connect);
 gtk_widget_destroy(wdg_login);

 /**************************************************************************/

 if (connected)
 {
  pixmap = gdk_pixmap_create_from_xpm(statbar->window, NULL/*&mask*/,
                                      NULL/*&style->bg[GTK_STATE_NORMAL]*/,
                                      CONNECT1_XPM);
 }
 else
 {
  pixmap = gdk_pixmap_create_from_xpm(statbar->window, NULL/*&mask*/,
                                      NULL/*&style->bg[GTK_STATE_NORMAL]*/,
                                      CONNECT0_XPM);
 }

 wdg_connect = gtk_pixmap_new (pixmap, NULL/*mask*/);

 gtk_box_pack_start(GTK_BOX(statbar), wdg_connect, FALSE, FALSE, 3);
                                    
 gtk_widget_show(wdg_connect);

 /***************************************************************************/

 if (logged_in)
 {
  pixmap = gdk_pixmap_create_from_xpm(statbar->window, NULL/*&mask*/,
                                      NULL/*&style->bg[GTK_STATE_NORMAL]*/,
                                      LOGIN1_XPM);
 }
 else
 {
  pixmap = gdk_pixmap_create_from_xpm(statbar->window, NULL/*&mask*/,
                                      NULL/*&style->bg[GTK_STATE_NORMAL]*/,
                                      LOGIN0_XPM);
 }

 wdg_login = gtk_pixmap_new(pixmap, NULL/*mask*/);

 gtk_box_pack_start(GTK_BOX(statbar), wdg_login, FALSE, FALSE, 3);

 gtk_widget_show(wdg_login);
}


