/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* sock.h  --  socket-related code */


#ifndef SOCK_H
#define SOCK_H    /* To stop multiple inclusions. */


#include <sys/types.h> 
#include <sys/socket.h> /* struct sockaddr */
#include <netinet/in.h> /* struct sockaddr_in */
#include "portable.h"

int create_socket(void);
int close_socket(int sockfd);

void init_sockaddr(struct sockaddr_in *some_addr, char *serverip, int portnr);

int connect_to_socket(int sockfd, struct sockaddr_in *some_addr);

char *resolve_hostname(const char *hostname);


#endif /* SOCK_H */

