/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* sock.c  --  socket-related code */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "defaults.h"
#include "log.h"
#include "conf.h"

#include "sock.h"


/******************************************************************************
 Create an internet stream socket and return its descriptor.
******************************************************************************/
int create_socket(void)
{
 int sockfd;

 if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
 {
  lerror("create_socket:socket");
  return -1;
 }
 return sockfd;
}

/******************************************************************************
 Close the socket sockfd.
******************************************************************************/
int close_socket(int sockfd)
{
 if (close(sockfd) < 0)
 {
  lerror("close_socket:close");
  return -1;
 }
 return 0;
}

/******************************************************************************
 Initialize the sockaddr_in struct.
******************************************************************************/
void init_sockaddr(struct sockaddr_in *some_addr, char *serverip, int portnr)
{
 memset(some_addr, 0, sizeof(*some_addr));
 some_addr->sin_family = AF_INET;
 some_addr->sin_port = htons(portnr);
 some_addr->sin_addr.s_addr = inet_addr(serverip);
}

/******************************************************************************
 Connect() to a socket.
******************************************************************************/
int connect_to_socket(int sockfd, struct sockaddr_in *some_addr)
{
 if (connect(sockfd, some_addr, (socklen_t)sizeof(*some_addr)) < 0)
 {
  lerror("connect_to_socket:connect");
  return -1;
 }
 return 0;
}

/******************************************************************************
 Resolve a hostname, if it's not an IP already. Returns a 'malloc'ed pointer.
 You must free() is if don't use it anymore. Returns NULL on errror.
******************************************************************************/
char *resolve_hostname(const char *hostname)
{
 struct hostent *hostdata;
 char *tmp;

/* if (inet_addr(hostname) < 0)
 {
  lerror("resolve_hostname:inet_addr");
  ghtslog(GHTSLOG_DEBUG,
          "resolve_hostname: inet_addr failed. Trying gethostbyname.");
*/
  if ((hostdata = gethostbyname(hostname)) == NULL)
  {
   herror("resolve_hostname:gethostbyname");
   return NULL;
  }

  if ((tmp = malloc((size_t)15+1)) == NULL)
  {
   lerror("resolve_hostname:malloc");
   return NULL;
  }

  tmp = inet_ntoa(*((struct in_addr *)hostdata->h_addr));

  return tmp;
/* }
  
 return hostname;*/  /* it was an IP already */
}


