/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* protocol.c  --  htsprotocol implementation */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "log.h"
#include "net.h"
#include "conf.h"
#include "data.h"
#include "logindialog.h"
#include "statusbar.h"
#include "menu.h"

#include "protocol.h"


#define PROTOCOL_VERSION "0.4.2"  /* htsprotocol version */

#define MAX_LEN_SERVER_REPLY 256


/*****************************************************************************/
int p_login(const char *playername, const char *password)
{
 char buf[MAX_LEN_SERVER_REPLY+1];

 ghtslog(GHTSLOG_INFO, "p_login().");

 send_to_server("login \"%s\" \"%s\"", playername, password);

 recv_from_server((char *)&buf, MAX_LEN_SERVER_REPLY);
 ghtslog(GHTSLOG_DEBUG, "htsserver reply: %s", buf);

 /* TODO this is a temporary solution and must be improved */
 if (strncmp(buf, "Login successful.\n", MAX_LEN_SERVER_REPLY) == 0)
  return 0;
 else 
  return -1;
}

/*****************************************************************************/
int p_logout(void)
{
 send_to_server("logout");
 logged_in = NO;
 ghts_update_statusbar();
 m_logout();
 free(login_playername);
 ghtslog(GHTSLOG_INFO, "p_logout().");
 return 0;
}

/*****************************************************************************/
int p_addplayer(const char *playername, const char *password)
{
 char buf[MAX_LEN_SERVER_REPLY+1];

 ghtslog(GHTSLOG_INFO, "p_addplayer().");

 send_to_server("addplayer \"%s\" \"%s\"", playername, password);

 recv_from_server((char *)&buf, MAX_LEN_SERVER_REPLY);
 ghtslog(GHTSLOG_DEBUG, "htsserver reply: %s", buf);

 /* TODO this is a *very* temporary solution and must be improved */
 if (strncmp(buf, "New player", strlen("New player")) == 0)
  return 0;
 else
 {
  if (strncmp(buf, "Player already exists.", strlen("Player already exists.")) == 0)
   return -2;
  else
   return -1;
 }
}

/*****************************************************************************/
int p_delplayer(const char *playername)
{
 char buf[MAX_LEN_SERVER_REPLY+1];

 ghtslog(GHTSLOG_INFO, "p_delplayer().");

 send_to_server("delplayer \"%s\"", playername);

 recv_from_server((char *)&buf, MAX_LEN_SERVER_REPLY);
 ghtslog(GHTSLOG_DEBUG, "htsserver reply: %s", buf);

 /* TODO this is a temporary solution and must be improved */
 if (strncmp(buf, "Player successfully deleted.\n", MAX_LEN_SERVER_REPLY) == 0)
  return 0;
 else
  return -1;
}


