/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* misc.c  --  miscellaneous code */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include "log.h"
#include "defaults.h"
#include "file.h"
#include "conf.h"
#include "net.h"
#include "protocol.h"
#include "logindialog.h"

#include "misc.h"


static void signal_handler_exit(int signum);
static void signal_handler_config(int signum);


/*****************************************************************************/
void setup_signal_handling(void)
{
 if (signal(SIGTERM, signal_handler_exit) == SIG_IGN)
  (void) signal(SIGTERM, SIG_IGN);
 if (signal(SIGINT, signal_handler_exit) == SIG_IGN)
  (void) signal(SIGINT, SIG_IGN);
 if (signal(SIGQUIT, signal_handler_exit) == SIG_IGN)
  (void) signal(SIGQUIT, SIG_IGN);
 if (signal(SIGABRT, signal_handler_exit) == SIG_IGN)
  (void) signal(SIGABRT, SIG_IGN);

 if (signal(SIGHUP, signal_handler_config) == SIG_IGN)
  (void) signal(SIGHUP, SIG_IGN);
}


/******************************************************************************
 Chop a string into pieces somehow similar to strtok() but with support for
 quoted substrings. This function also doesn't touch it's first argument. It
 returns strings allocated using malloc() which should be free()d when not
 needed any longer. Returns NULL on error.
******************************************************************************/
char *strchop(const char *string, const char *delimiters)
{
 static const char *save;  /* to save our position */
 const char quote = '\"';  /* the quote character */

 int inquote = 0;          /* are we in a quoted substring? */
 char *sub;                /* substring */
 size_t len;               /* substring length */

 if (string != NULL)  /* FIXME if (string == NULL) save won't be initialized */
  save = string;

 /* skip leading delimiters */
 while ((strchr(delimiters, *save) != NULL) && (*save != '\0'))
  save++;

 /* check for an opening quote */
 if (*save == quote)
 {
  inquote = 1;
  save++;
 }

 /* return NULL if end of string reached */
 if (*save == '\0')
  return NULL;

 /* count length of substring */
 if (inquote == 1)
  for (len=0; ((save[len] != '\0') && (save[len] != quote)); len++);
 else
  for (len=0; (save[len] != '\0')
       && (strchr(delimiters, save[len]) == NULL); len++);


 if ((sub = malloc(len+1)) == NULL)
  return NULL;

 /* save substring */
 (void) memcpy(sub, save, len);
 sub[len] = '\0';

 /* advance save pointer to character immediately after substring */
 save += len;

 /* if we didn't hit '\0' skip over the deliminating character, too */
 if (*save != '\0')
  save++;

 return sub;
}

/*****************************************************************************/
static void signal_handler_exit(int signum)
{
 ghtslog(GHTSLOG_INFO, "Signal %d received -> controlled shutdown.", signum);

 if (logged_in)
  p_logout();

 if (connected)
  server_disconnect();

 ghtslog(GHTSLOG_INFO, "Shutting down.");

 gtk_main_quit();

 exit(EXIT_SUCCESS);
}

/*****************************************************************************/
static void signal_handler_config(int signum)
{
 ghtslog(GHTSLOG_INFO, "Signal %d received -> re-read config-file.", signum);
 if (parse_cfile() < 0)
  ghtslog(GHTSLOG_ERROR, "Error re-reading config-file.");
 /* FIXME This will override command line options */
}

