/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* messagedialog.c  --  the message-dialog */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include "log.h"
#include "misc.h"
#include "protocol.h"
#include "data.h"

#include "messagedialog.h"


static void destroy_message_dialog(GtkWidget *widget, gpointer data);

/*****************************************************************************/
void message_dialog(const char *title, const char *content)
{
 GtkWidget *a_dialog;
 GtkWidget *a_label;
 GtkWidget *a_hbox;
 GtkWidget *a_button;

 
 a_dialog = gtk_dialog_new();
 
 gtk_window_set_title(GTK_WINDOW(a_dialog), title);
 gtk_window_position(GTK_WINDOW(a_dialog), GTK_WIN_POS_CENTER);
 
 /****************************************************************************/

 a_hbox = gtk_hbox_new(FALSE, 2);
 
 a_label = gtk_label_new(content);
 gtk_box_pack_start(GTK_BOX(a_hbox), a_label, FALSE, FALSE, 5);
 gtk_widget_show(a_label);
 
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->vbox), a_hbox,
                    FALSE, FALSE, 5);
                    
 gtk_widget_show(a_hbox);
 
 /****************************************************************************/
 
 a_button = gtk_button_new_with_label("OK");
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->action_area),
                    a_button, FALSE, FALSE, 5);
 gtk_signal_connect(GTK_OBJECT(a_button), "clicked",
                    GTK_SIGNAL_FUNC(destroy_message_dialog), a_dialog);
 gtk_widget_show(a_button);
 
 /****************************************************************************/
 
 gtk_widget_show(a_dialog);
}

/*****************************************************************************/
static void destroy_message_dialog(GtkWidget *widget, gpointer data)
{
 gtk_widget_destroy(data);
}

