/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* menu.c  --  code for the menu */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include "log.h"
#include "protocol.h"
#include "net.h"
#include "mainwin.h"
#include "logindialog.h"
#include "about.h"
#include "data.h"
#include "messagedialog.h"
#include "addplayerdialog.h"
#include "delplayerdialog.h"
#include "connectdialog.h"

#include "menu.h"


static void init_menu(void);
static void set_menu_sensitivity(gchar *path, gint value);

static void logout(GtkWidget *widget, gpointer data);
static void login(GtkWidget *widget, gpointer data);

static void disconnect(GtkWidget *widget, gpointer data);
static void connect(GtkWidget *widget, gpointer data);
static void addplayer(GtkWidget *widget, gpointer data);
static void delplayer(GtkWidget *widget, gpointer data);


GtkItemFactory *item_factory;

static GtkItemFactoryEntry menu_items[] =
{
 {"/_Main",              NULL,         NULL,               0, "<Branch>"},
 {"/Main/_Connect",      "<control>C", connect,            0, "<Item>"},
 {"/Main/_Disconnect",   "<control>D", disconnect,         0, "<Item>"},
 {"/Main/sep1",          NULL,         NULL,               0, "<Separator>"},
 {"/Main/_Quit",         "q",          ghts_shutdown,      0, "<Item>"},

 {"/_Server",            NULL,         NULL,               0, "<Branch>"},
 {"/Server/Add player",  NULL,         addplayer,          0, "<Item>"},
 {"/Server/Delete player",  NULL,      delplayer,          0, "<Item>"},
 {"/Server/sep2",        NULL,         NULL,               0, "<Separator>"},
 {"/Server/Login",       NULL,         login,              0, "<Item>"},
 {"/Server/Logout",      NULL,         logout,             0, "<Item>"},

 {"/_Options",           NULL,         NULL,               0, "<Branch>"},
 {"/Options/General",    NULL,         NULL,               0, "<Item>"},
 {"/Options/Console",    NULL,         NULL,               0, "<Item>"},

 {"/_View",              NULL,         NULL,               0, "<Branch>"},
 {"/View/Trade-win",     NULL,         NULL,               0, "<Item>"},
 {"/View/Status-win",    NULL,         NULL,               0, "<Item>"},

 {"/_Help",              NULL,         NULL,               0, "<LastBranch>"},
 {"/Help/Manual",        NULL,         NULL,               0, "<Item>"},
 {"/Help/License",       NULL,         NULL,               0, "<Item>"},
 {"/Help/sep3",          NULL,         NULL,               0, "<Separator>"},
 {"/Help/_About",        NULL,         ghts_about,         0, "<Item>"},
};


/*****************************************************************************/
void ghts_menu(GtkWidget *window, GtkBox *some_box)
{
 GtkWidget *menubar;
 GtkAccelGroup *accel_group;
 gint nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);

 accel_group = gtk_accel_group_new();

 item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accel_group);

 gtk_item_factory_create_items(item_factory, nmenu_items, menu_items, NULL);

 gtk_accel_group_attach(accel_group, GTK_OBJECT(window));

 menubar = gtk_item_factory_get_widget(item_factory, "<main>");

 gtk_box_pack_start(GTK_BOX(some_box), menubar, FALSE, TRUE, 0);

 init_menu();

 gtk_widget_show(menubar);

 ghtslog(GHTSLOG_DEBUG, "Creating menu.");
}

/*****************************************************************************/
void init_menu(void)
{
 set_menu_sensitivity("/Main/Disconnect", FALSE);

 set_menu_sensitivity("/Server/Add player", FALSE);
 set_menu_sensitivity("/Server/Delete player", FALSE);
 set_menu_sensitivity("/Server/Login", FALSE);
 set_menu_sensitivity("/Server/Logout", FALSE);

 set_menu_sensitivity("/Options/General", FALSE);
 set_menu_sensitivity("/Options/Console", FALSE);
 
 set_menu_sensitivity("/View/Trade-win", FALSE);
 set_menu_sensitivity("/View/Status-win", FALSE);

 set_menu_sensitivity("/Help/Manual", FALSE);
 set_menu_sensitivity("/Help/License", FALSE);
}

/*****************************************************************************/
static void set_menu_sensitivity(gchar *path, gint value)
{
 GtkWidget *menu;
  
 if ((menu = gtk_item_factory_get_widget(item_factory, path)) != NULL)
  gtk_widget_set_sensitive(menu, value);
}   

/*****************************************************************************/
void m_connect(void)
{
 set_menu_sensitivity("/Main/Connect", FALSE);
 set_menu_sensitivity("/Main/Disconnect", TRUE);

 set_menu_sensitivity("/Server/Add player", TRUE);
 set_menu_sensitivity("/Server/Login", TRUE);
}

/*****************************************************************************/
void m_disconnect(void)
{
 set_menu_sensitivity("/Main/Connect", TRUE);
 set_menu_sensitivity("/Main/Disconnect", FALSE);

 set_menu_sensitivity("/Server/Add player", FALSE);
 set_menu_sensitivity("/Server/Delete player", FALSE);
 set_menu_sensitivity("/Server/Login", FALSE);
 set_menu_sensitivity("/Server/Logout", FALSE);
}

/*****************************************************************************/
void m_login(void)
{
 set_menu_sensitivity("/Server/Delete player", TRUE);
 set_menu_sensitivity("/Server/Login", FALSE);
 set_menu_sensitivity("/Server/Logout", TRUE);
}

/*****************************************************************************/
void m_logout(void)
{
 set_menu_sensitivity("/Server/Delete player", FALSE);
 set_menu_sensitivity("/Server/Login", TRUE);
 set_menu_sensitivity("/Server/Logout", FALSE);
}

/*****************************************************************************/
static void login(GtkWidget *widget, gpointer data)
{
 if (login_dialog_on)
 {
  ghtslog(GHTSLOG_ERROR, "Login dialog already open.");
  message_dialog("Error:", "Login dialog already open.");
  return;
 }
 login_dialog();
}

/*****************************************************************************/
static void logout(GtkWidget *widget, gpointer data)
{
 p_logout();
}

/*****************************************************************************/
static void connect(GtkWidget *widget, gpointer data)
{
 if (connect_dialog_on)
 {
  ghtslog(GHTSLOG_ERROR, "Connect dialog already open.");
  message_dialog("Error:", "Connect dialog already open.");
  return;
 }
 connect_dialog();
}

/*****************************************************************************/
static void disconnect(GtkWidget *widget, gpointer data)
{
 server_disconnect();
}

/*****************************************************************************/
static void addplayer(GtkWidget *widget, gpointer data)
{
 if (addplayer_dialog_on)
 {
  ghtslog(GHTSLOG_ERROR, "Addplayer dialog already open.");
  message_dialog("Error:", "Addplayer dialog already open.");
  return;
 }
 addplayer_dialog();
}

/*****************************************************************************/
static void delplayer(GtkWidget *widget, gpointer data)
{
 if (delplayer_dialog_on)
 {
  ghtslog(GHTSLOG_ERROR, "Delplayer dialog already open.");
  message_dialog("Error:", "Delplayer dialog already open.");
  return;
 }
 delplayer_dialog();
}


