/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* mainwin.c  --  code for the main window */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include "log.h"
#include "protocol.h"
#include "menu.h"
#include "net.h"
#include "logindialog.h"
#include "statusbar.h"

#include "mainwin.h"


/*****************************************************************************/
void main_win(void)
{
 GtkWidget *window;
 GtkWidget *main_vbox;

 /****************************************************************************/
 window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_window_set_title(GTK_WINDOW(window), "GTK+ Holsham Traders Client");
 gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);

 gtk_widget_set_usize(GTK_WIDGET(window),
                      (gint)(0.6 * gdk_screen_width()),
                      (gint)(0.6 * gdk_screen_height()));

 gtk_signal_connect(GTK_OBJECT(window), "delete_event", 
                    GTK_SIGNAL_FUNC(ghts_shutdown), NULL);

 /****************************************************************************/

 main_vbox = gtk_vbox_new(FALSE, 1);
 gtk_container_border_width(GTK_CONTAINER(main_vbox), 1);
 gtk_container_add(GTK_CONTAINER(window), main_vbox);
 gtk_widget_show(main_vbox);

 /****************************************************************************/

 ghts_menu(GTK_WIDGET(window), GTK_BOX(main_vbox));
 ghts_statusbar(GTK_WIDGET(window), GTK_BOX(main_vbox));

 gtk_widget_show(window);
}

/*****************************************************************************/
void ghts_shutdown(GtkWidget *widget, GdkEvent *event, gpointer data)
{
 if (logged_in)
  p_logout();

 if (connected)
  server_disconnect();

 ghtslog(GHTSLOG_INFO, "Shutting down.");
 gtk_main_quit();
}

