/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* logindialog.c  --  the login-dialog */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "log.h"
#include "misc.h"
#include "protocol.h"
#include "data.h"
#include "menu.h"
#include "statusbar.h"
#include "conf.h"
#include "net.h"
#include "messagedialog.h"

#include "logindialog.h"


static GtkWidget *a_dialog;
static GtkWidget *playername_field;
static GtkWidget *password_field;

/*Flags*/
bool logged_in = NO;
bool login_dialog_on = NO;

/*globals*/
char *login_playername;

static void login_callback(GtkWidget *widget, gpointer data);
static void destroy_login_dialog(GtkWidget *widget, gpointer data);

/*****************************************************************************/
void login_dialog(void)
{
 GtkWidget *a_label;
 GtkWidget *a_hbox;
 GtkWidget *a_button;
 
 login_dialog_on = YES;
 
 a_dialog = gtk_dialog_new();
 
 gtk_window_set_title(GTK_WINDOW(a_dialog), "Login");
 gtk_window_position(GTK_WINDOW(a_dialog), GTK_WIN_POS_CENTER);
 gtk_signal_connect(GTK_OBJECT(a_dialog), "delete_event",
                    GTK_SIGNAL_FUNC(destroy_login_dialog), NULL);
 
 /****************************************************************************/

 a_hbox = gtk_hbox_new(FALSE, 2);
 
 a_label = gtk_label_new("Playername:");
 gtk_box_pack_start(GTK_BOX(a_hbox), a_label, FALSE, FALSE, 5);
 gtk_widget_show(a_label);
 
 playername_field = gtk_entry_new_with_max_length(MAX_LEN_PLAYERNAME);
 gtk_box_pack_start(GTK_BOX(a_hbox), playername_field, FALSE, FALSE, 5);
 gtk_widget_show(playername_field);
 
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->vbox), a_hbox,
                    FALSE, FALSE, 5);
                    
 gtk_widget_show(a_hbox);
 
 /****************************************************************************/
 
 a_hbox = gtk_hbox_new(FALSE, 2);
 
 a_label = gtk_label_new("Password:");
 gtk_box_pack_start(GTK_BOX(a_hbox), a_label, FALSE, FALSE, 5);
 gtk_widget_show(a_label);
 
 password_field = gtk_entry_new_with_max_length(MAX_LEN_PASSWORD); 
 gtk_box_pack_start(GTK_BOX(a_hbox), password_field, FALSE, FALSE, 5);
 gtk_entry_set_visibility(GTK_ENTRY(password_field), FALSE);
 gtk_widget_show(password_field);

 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->vbox), a_hbox,
                    FALSE, FALSE, 5);
 
 gtk_widget_show(a_hbox);
 
 /****************************************************************************/

 a_button = gtk_button_new_with_label("Login");
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->action_area),
                    a_button, FALSE, FALSE, 5);
 gtk_signal_connect(GTK_OBJECT(a_button), "clicked",
                    GTK_SIGNAL_FUNC(login_callback), NULL);
 gtk_widget_show(a_button);
 
 /****************************************************************************/
 
 a_button = gtk_button_new_with_label("Cancel");
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->action_area),
                    a_button, FALSE, FALSE, 5);
 gtk_signal_connect(GTK_OBJECT(a_button), "clicked",
                    GTK_SIGNAL_FUNC(destroy_login_dialog), NULL);
 gtk_widget_show(a_button);
 
 /****************************************************************************/
 
 gtk_widget_show(a_dialog);
}

/*****************************************************************************/
static void login_callback(GtkWidget *widget, gpointer data)
{
 char *password = gtk_entry_get_text(GTK_ENTRY(password_field));

 if (!connected)
 {
  logged_in = NO;
  ghts_update_statusbar();
  gtk_widget_destroy(a_dialog);
  login_dialog_on = NO;
  ghtslog(GHTSLOG_ERROR, "Trying to login when not connected.");
  message_dialog("Error:", "You have to be connected to do this.");
  return;
 }

 if ((login_playername = malloc(strlen(gtk_entry_get_text(GTK_ENTRY(playername_field)))+1)) == NULL)
 {
  lerror("login_callback:malloc");
  return;
 }
 strcpy(login_playername, gtk_entry_get_text(GTK_ENTRY(playername_field)));


 if (p_login(login_playername, password) < 0)
 {
  ghtslog(GHTSLOG_ERROR, "Login failed.");
  message_dialog("Error:", "Login failed.");
 }
 else
 {
  logged_in = YES;
  ghts_update_statusbar();
  m_login();
  gtk_widget_destroy(a_dialog);
  login_dialog_on = NO;
  ghtslog(GHTSLOG_DEBUG, "Login successful.");
 }
 
}   

/*****************************************************************************/
static void destroy_login_dialog(GtkWidget *widget, gpointer data)
{
 login_dialog_on = NO;
 gtk_widget_destroy(a_dialog);
}


