/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* delplayerdialog.c  --  the delplayer-dialog */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include "log.h"
#include "misc.h"
#include "protocol.h"
#include "data.h"
#include "menu.h"
#include "statusbar.h"
#include "conf.h"
#include "logindialog.h"
#include "net.h"
#include "messagedialog.h"

#include "delplayerdialog.h"


static GtkWidget *a_dialog;

/*Flags*/
bool delplayer_dialog_on = NO;

static void delplayer_callback(GtkWidget *widget, gpointer data);
static void destroy_delplayer_dialog(GtkWidget *widget, gpointer data);

/*****************************************************************************/
void delplayer_dialog(void)
{
 GtkWidget *a_label;
 GtkWidget *a_hbox;
 GtkWidget *a_button;
 char tmp[1024];
 
 delplayer_dialog_on = YES;
 
 a_dialog = gtk_dialog_new();
 
 gtk_window_set_title(GTK_WINDOW(a_dialog), "Delete player");
 gtk_window_position(GTK_WINDOW(a_dialog), GTK_WIN_POS_CENTER);
 gtk_signal_connect(GTK_OBJECT(a_dialog), "delete_event",
                    GTK_SIGNAL_FUNC(destroy_delplayer_dialog), NULL);
 
 /****************************************************************************/

 a_hbox = gtk_hbox_new(FALSE, 2);

 sprintf(tmp, "Do you really want to delete the player \"%s\"?",
              login_playername);

 a_label = gtk_label_new(tmp);
 gtk_box_pack_start(GTK_BOX(a_hbox), a_label, FALSE, FALSE, 5);
 gtk_widget_show(a_label);
 
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->vbox), a_hbox,
                    FALSE, FALSE, 5);
                    
 gtk_widget_show(a_hbox);
 
 /****************************************************************************/

 a_button = gtk_button_new_with_label("Delete");
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->action_area),
                    a_button, FALSE, FALSE, 5);
 gtk_signal_connect(GTK_OBJECT(a_button), "clicked",
                    GTK_SIGNAL_FUNC(delplayer_callback), NULL);
 gtk_widget_show(a_button);
 
 /****************************************************************************/
 
 a_button = gtk_button_new_with_label("Cancel");
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->action_area),
                    a_button, FALSE, FALSE, 5);
 gtk_signal_connect(GTK_OBJECT(a_button), "clicked",
                    GTK_SIGNAL_FUNC(destroy_delplayer_dialog), NULL);
 gtk_widget_show(a_button);
 
 /****************************************************************************/
 
 gtk_widget_show(a_dialog);
}

/*****************************************************************************/
static void delplayer_callback(GtkWidget *widget, gpointer data)
{
 if (!connected)
 {
  gtk_widget_destroy(a_dialog);
  delplayer_dialog_on = NO;
  ghts_update_statusbar();
  m_disconnect();
  free(login_playername);
  ghtslog(GHTSLOG_ERROR, "Trying to delete player when not connected.");
  message_dialog("Error:", "You have to be connected to do this.");
  return;
 }

 if (p_delplayer(login_playername) < 0)
 {
  ghtslog(GHTSLOG_ERROR, "Delplayer failed.");
  message_dialog("Error:", "Delplayer failed.");
 }
 else
 {
  gtk_widget_destroy(a_dialog);
  delplayer_dialog_on = NO;
  logged_in = NO;
  ghts_update_statusbar();
  m_logout();
  free(login_playername);
  ghtslog(GHTSLOG_DEBUG, "Delplayer successful.");
 }
 
}   

/*****************************************************************************/
static void destroy_delplayer_dialog(GtkWidget *widget, gpointer data)
{
 delplayer_dialog_on = NO;
 gtk_widget_destroy(a_dialog);
}


