/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* defaults.h  --  compile-time options for ghtsclient */


#ifndef DEFAULTS_H
#define DEFAULTS_H    /* To stop multiple inclusions. */


/* default IP to connect to */
#define SERVER_IP "localhost"

/* default port number to connect to */
#define PORT_NUMBER 1919

/******************************************************************************
 Default verbosity-level. Possible values:
 0: log nothing
 1: log only errors
 2: log errors and infos
 3: log errors, infos, and debug-messages
******************************************************************************/
#define DEFAULT_VERBOSITY 2

/******************************************************************************
 Default logging-destination. Possible values:
 0: log to stderr
 1: log to a file
 2: log using syslog
******************************************************************************/
#define DEFAULT_LOGDEST 1

/******************************************************************************
 Default filename for file logging. The file will be created in the
 ~/.ghtsclient directory.
******************************************************************************/
#define DEFAULT_LOGFILE "ghtsclient.log"

/******************************************************************************
 Default configuration-file. Is expected to be in ~/.ghtsclient.
******************************************************************************/
#define DEFAULT_CONFIGFILE "ghtsclient.conf"


#endif /* DEFAULTS_H */

