/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* connectdialog.c  --  the connect-dialog */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include "log.h"
#include "misc.h"
#include "protocol.h"
#include "data.h"
#include "defaults.h"
#include "net.h"
#include "sock.h"
#include "messagedialog.h"

#include "connectdialog.h"


#define MAX_LEN_SERVER_NAME 30
#define MAX_LEN_PORT        5


static GtkWidget *a_dialog;
static GtkWidget *servername_field;
static GtkWidget *port_field;

/*Flags*/
bool connect_dialog_on = NO;

static void connect_callback(GtkWidget *widget, gpointer data);
static void destroy_connect_dialog(GtkWidget *widget, gpointer data);

/*****************************************************************************/
void connect_dialog(void)
{
 GtkWidget *a_label;
 GtkWidget *a_hbox;
 GtkWidget *a_button;
 char tmp[5];          /* temporary! this must be improved */
 
 connect_dialog_on = YES;
 
 a_dialog = gtk_dialog_new();
 
 gtk_window_set_title(GTK_WINDOW(a_dialog), "Connect");
 gtk_window_position(GTK_WINDOW(a_dialog), GTK_WIN_POS_CENTER);
 gtk_signal_connect(GTK_OBJECT(a_dialog), "delete_event",
                    GTK_SIGNAL_FUNC(destroy_connect_dialog), NULL);
 
 /****************************************************************************/

 a_hbox = gtk_hbox_new(FALSE, 2);
 
 a_label = gtk_label_new("Servername/IP:");
 gtk_box_pack_start(GTK_BOX(a_hbox), a_label, FALSE, FALSE, 5);
 gtk_widget_show(a_label);
 
 servername_field = gtk_entry_new_with_max_length(MAX_LEN_SERVER_NAME);
 gtk_box_pack_start(GTK_BOX(a_hbox), servername_field, FALSE, FALSE, 5);
 gtk_entry_set_text(servername_field, SERVER_IP);
 gtk_widget_show(servername_field);
 
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->vbox), a_hbox,
                    FALSE, FALSE, 5);
                    
 gtk_widget_show(a_hbox);
 
 /****************************************************************************/
 
 a_hbox = gtk_hbox_new(FALSE, 2);
 
 a_label = gtk_label_new("Port:");
 gtk_box_pack_start(GTK_BOX(a_hbox), a_label, FALSE, FALSE, 5);
 gtk_widget_show(a_label);

 snprintf(tmp, 5, "%d", PORT_NUMBER);
 
 port_field = gtk_entry_new_with_max_length(MAX_LEN_PORT); 
 gtk_box_pack_start(GTK_BOX(a_hbox), port_field, FALSE, FALSE, 5);
 gtk_entry_set_text(port_field, tmp);
 gtk_widget_show(port_field);

 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->vbox), a_hbox,
                    FALSE, FALSE, 5);
 
 gtk_widget_show(a_hbox);
 
 /****************************************************************************/

 a_button = gtk_button_new_with_label("Connect");
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->action_area),
                    a_button, FALSE, FALSE, 5);
 gtk_signal_connect(GTK_OBJECT(a_button), "clicked",
                    GTK_SIGNAL_FUNC(connect_callback), NULL);
 gtk_widget_show(a_button);
 
 /****************************************************************************/
 
 a_button = gtk_button_new_with_label("Cancel");
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->action_area),
                    a_button, FALSE, FALSE, 5);
 gtk_signal_connect(GTK_OBJECT(a_button), "clicked",
                    GTK_SIGNAL_FUNC(destroy_connect_dialog), NULL);
 gtk_widget_show(a_button);
 
 /****************************************************************************/
 
 gtk_widget_show(a_dialog);
}

/*****************************************************************************/
static void connect_callback(GtkWidget *widget, gpointer data)
{
 char *servername = gtk_entry_get_text(GTK_ENTRY(servername_field));
 char *port = gtk_entry_get_text(GTK_ENTRY(port_field));
 char *tmp;


 if ((tmp = resolve_hostname(servername)) == NULL)
  tmp = servername;

 if (server_connect(tmp, atoi(port)) < 0)
 {
  ghtslog(GHTSLOG_ERROR, "Connect failed.");
  message_dialog("Error:", "Connect failed.");
 }
 else
 {
  gtk_widget_destroy(a_dialog);
  connect_dialog_on = NO;
  ghtslog(GHTSLOG_DEBUG, "Connect successful.");
 }
 
}   

/*****************************************************************************/
static void destroy_connect_dialog(GtkWidget *widget, gpointer data)
{
 connect_dialog_on = NO;
 gtk_widget_destroy(a_dialog);
}


