/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* conf.h  --  configuration code */


#ifndef CONF_H
#define CONF_H    /* To stop multiple inclusions. */


#define MAX_LEN_PLAYERNAME 30
#define MAX_LEN_PASSWORD   80


/* Procedure for adding new config options:
 *  -Add the config variable to conf_t here in conf.h.
 *  -Add it to the handler table in conf.c.
 *  -Add a default value for it in defaults.h
 *  -Initialize it to that default in init_conf() in conf.c.
 *  -Write an entry in ghtsclient.conf
 *  -Update the docs
 */

typedef struct conf_t
{
 unsigned short int port;
 char *server_ip;
 int verbosity;
 int logdest;
 char *logfile;
} conf_t;


/* data-type which is used to store the configuration options */
extern conf_t conf;

/* run-time configuration initialization */
void init_conf(void);

/* config file parser function */
int parse_cfile(void);


#endif /* CONF_H */

