/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* addplayerdialog.c  --  the addplayer-dialog */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include "log.h"
#include "misc.h"
#include "protocol.h"
#include "data.h"
#include "conf.h"
#include "net.h"
#include "messagedialog.h"

#include "addplayerdialog.h"


static GtkWidget *a_dialog;
static GtkWidget *playername_field;
static GtkWidget *password_field;

/*Flags*/
bool addplayer_dialog_on = NO;

static void addplayer_callback(GtkWidget *widget, gpointer data);
static void destroy_addplayer_dialog(GtkWidget *widget, gpointer data);

/*****************************************************************************/
void addplayer_dialog(void)
{
 GtkWidget *a_label;
 GtkWidget *a_hbox;
 GtkWidget *a_button;
 
 addplayer_dialog_on = YES;
 
 a_dialog = gtk_dialog_new();
 
 gtk_window_set_title(GTK_WINDOW(a_dialog), "Add player");
 gtk_window_position(GTK_WINDOW(a_dialog), GTK_WIN_POS_CENTER);
 gtk_signal_connect(GTK_OBJECT(a_dialog), "delete_event",
                    GTK_SIGNAL_FUNC(destroy_addplayer_dialog), NULL);
 
 /****************************************************************************/

 a_hbox = gtk_hbox_new(FALSE, 2);
 
 a_label = gtk_label_new("Playername:");
 gtk_box_pack_start(GTK_BOX(a_hbox), a_label, FALSE, FALSE, 5);
 gtk_widget_show(a_label);
 
 playername_field = gtk_entry_new_with_max_length(MAX_LEN_PLAYERNAME);
 gtk_box_pack_start(GTK_BOX(a_hbox), playername_field, FALSE, FALSE, 5);
 gtk_widget_show(playername_field);
 
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->vbox), a_hbox,
                    FALSE, FALSE, 5);
                    
 gtk_widget_show(a_hbox);
 
 /****************************************************************************/
 
 a_hbox = gtk_hbox_new(FALSE, 2);
 
 a_label = gtk_label_new("Password:");
 gtk_box_pack_start(GTK_BOX(a_hbox), a_label, FALSE, FALSE, 5);
 gtk_widget_show(a_label);
 
 password_field = gtk_entry_new_with_max_length(MAX_LEN_PASSWORD); 
 gtk_box_pack_start(GTK_BOX(a_hbox), password_field, FALSE, FALSE, 5);
 gtk_entry_set_visibility(GTK_ENTRY(password_field), FALSE);
 gtk_widget_show(password_field);

 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->vbox), a_hbox,
                    FALSE, FALSE, 5);
 
 gtk_widget_show(a_hbox);
 
 /****************************************************************************/

 a_button = gtk_button_new_with_label("Add");
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->action_area),
                    a_button, FALSE, FALSE, 5);
 gtk_signal_connect(GTK_OBJECT(a_button), "clicked",
                    GTK_SIGNAL_FUNC(addplayer_callback), NULL);
 gtk_widget_show(a_button);
 
 /****************************************************************************/
 
 a_button = gtk_button_new_with_label("Cancel");
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->action_area),
                    a_button, FALSE, FALSE, 5);
 gtk_signal_connect(GTK_OBJECT(a_button), "clicked",
                    GTK_SIGNAL_FUNC(destroy_addplayer_dialog), NULL);
 gtk_widget_show(a_button);
 
 /****************************************************************************/
 
 gtk_widget_show(a_dialog);
}

/*****************************************************************************/
static void addplayer_callback(GtkWidget *widget, gpointer data)
{
 char *playername = gtk_entry_get_text(GTK_ENTRY(playername_field));
 char *password = gtk_entry_get_text(GTK_ENTRY(password_field));
 int error;
 
 if (!connected)
 {
  gtk_widget_destroy(a_dialog);
  addplayer_dialog_on = NO;
  ghtslog(GHTSLOG_ERROR, "Trying to add player when not connected.");
  message_dialog("Error:", "You have to be connected to do this.");
  return;
 }

 if ((error = p_addplayer(playername, password)) < 0)
 {
  if (error == -2)
  {
   ghtslog(GHTSLOG_ERROR, "Addplayer failed(Player already exists).");
   message_dialog("Error:", "Addplayer failed.\nPlayer already exists.");
  }
  else
  {
   ghtslog(GHTSLOG_ERROR, "Addplayer failed.");
   message_dialog("Error:", "Addplayer failed.");
  }
 }
 else
 {
  gtk_widget_destroy(a_dialog);
  addplayer_dialog_on = NO;
  ghtslog(GHTSLOG_DEBUG, "Addplayer successful.");
 }
 
}   

/*****************************************************************************/
static void destroy_addplayer_dialog(GtkWidget *widget, gpointer data)
{
 addplayer_dialog_on = NO;
 gtk_widget_destroy(a_dialog);
}


