/* ghtsclient - a GTK+ based client for the trading game Holsham Traders
   Copyright (C) 1999,2000 Piotr Esden-Tempski

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* about.c  --  the about-box */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include "log.h"

#include "about.h"


#define ABOUT_TEXT1 "\
ghtsclient "VERSION"\n\
a GTK+ based client for the trading game Holsham Traders\n\
released on "RELEASEDATE""

#define ABOUT_TEXT2 "\
Copyright (C) 1999,2000 Piotr Esden-Tempski\n\
<pe1724@bingo-ev.de>\n\n\
http://ghtsclient.sourceforge.net"

#define ABOUT_TEXT3 "\
This program is covered by the GNU General Public License (GPL)"

static void destroy_about_dialog(GtkWidget *widget, gpointer data);

/*****************************************************************************/
void ghts_about(GtkWidget *widget, gpointer data)
{
 GtkWidget *a_window;
 GtkWidget *a_vbox;
 GtkWidget *a_label;
 GtkWidget *a_separator;
 GtkWidget *a_button;

 a_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_window_set_title(GTK_WINDOW(a_window), "About");
 gtk_window_position(GTK_WINDOW(a_window), GTK_WIN_POS_CENTER);

 a_vbox = gtk_vbox_new(FALSE, 0);
 gtk_container_border_width(GTK_CONTAINER(a_vbox), 19);
 gtk_container_add(GTK_CONTAINER(a_window), a_vbox);

 a_label = gtk_label_new(ABOUT_TEXT1);
 gtk_box_pack_start(GTK_BOX(a_vbox), a_label, FALSE, FALSE, 5);
 gtk_widget_show(a_label);

 a_separator = gtk_hseparator_new();
 gtk_box_pack_start(GTK_BOX(a_vbox), a_separator, FALSE, TRUE, 5);
 gtk_widget_show(a_separator);
 
 a_label = gtk_label_new(ABOUT_TEXT2);
 gtk_box_pack_start(GTK_BOX(a_vbox), a_label, FALSE, FALSE, 5);
 gtk_widget_show(a_label);

 a_separator = gtk_hseparator_new();
 gtk_box_pack_start(GTK_BOX(a_vbox), a_separator, FALSE, TRUE, 5);
 gtk_widget_show(a_separator);

 a_label = gtk_label_new(ABOUT_TEXT3);
 gtk_box_pack_start(GTK_BOX(a_vbox), a_label, FALSE, FALSE, 5);
 gtk_widget_show(a_label);

 a_separator = gtk_hseparator_new();
 gtk_box_pack_start(GTK_BOX(a_vbox), a_separator, FALSE, TRUE, 5);
 gtk_widget_show(a_separator);

 a_button = gtk_button_new_with_label("OK");
 gtk_box_pack_start(GTK_BOX(a_vbox), a_button, FALSE, FALSE, 5);
 gtk_signal_connect(GTK_OBJECT(a_button), "clicked",
                    GTK_SIGNAL_FUNC(destroy_about_dialog), a_window);
 gtk_widget_show(a_button);


 gtk_widget_show(a_vbox);
 gtk_widget_show(a_window);

 ghtslog(GHTSLOG_DEBUG, "Showing About-window.");

}

/*****************************************************************************/
static void destroy_about_dialog(GtkWidget *widget, gpointer data)
{
 gtk_widget_destroy(data);
}
